/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.services.impl;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.data.services.AgentConnectionPersistenceService;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
public class AgentRoutingServiceImpl
implements AgentRoutingService {
    private static final Logger log = LoggerFactory.getLogger(AgentRoutingServiceImpl.class);
    private final AgentConnectionPersistenceService agentConnectionPersistenceService;
    private final GenieHostInfo genieHostInfo;

    public AgentRoutingServiceImpl(AgentConnectionPersistenceService agentConnectionPersistenceService, GenieHostInfo genieHostInfo) {
        this.agentConnectionPersistenceService = agentConnectionPersistenceService;
        this.genieHostInfo = genieHostInfo;
    }

    @Override
    public Optional<String> getHostnameForAgentConnection(@NotBlank String jobId) {
        return this.agentConnectionPersistenceService.lookupAgentConnectionServer(jobId);
    }

    @Override
    public boolean isAgentConnectionLocal(@NotBlank String jobId) {
        Optional<String> hostname = this.getHostnameForAgentConnection(jobId);
        return hostname.isPresent() && hostname.get().equals(this.genieHostInfo.getHostname());
    }

    @Override
    public void handleClientConnected(@NotBlank String jobId) {
        log.info("Agent executing job {} connected", (Object)jobId);
        this.agentConnectionPersistenceService.saveAgentConnection(jobId, this.genieHostInfo.getHostname());
    }

    @Override
    public void handleClientDisconnected(@NotBlank String jobId) {
        log.info("Agent executing job {} disconnected", (Object)jobId);
        this.agentConnectionPersistenceService.removeAgentConnection(jobId, this.genieHostInfo.getHostname());
    }

    @Override
    public boolean isAgentConnected(String jobId) {
        return this.getHostnameForAgentConnection(jobId).isPresent();
    }
}

