/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.ResolvedResources;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.ApplicationModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.ClusterModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.CommandModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.EntityModelAssemblers;
import com.netflix.genie.web.data.services.ClusterPersistenceService;
import com.netflix.genie.web.data.services.CommandPersistenceService;
import com.netflix.genie.web.data.services.DataServices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/commands"})
public class CommandRestController {
    private static final Logger log = LoggerFactory.getLogger(CommandRestController.class);
    private final CommandPersistenceService commandPersistenceService;
    private final ClusterPersistenceService clusterPersistenceService;
    private final CommandModelAssembler commandModelAssembler;
    private final ApplicationModelAssembler applicationModelAssembler;
    private final ClusterModelAssembler clusterModelAssembler;

    @Autowired
    public CommandRestController(DataServices dataServices, EntityModelAssemblers entityModelAssemblers) {
        this.commandPersistenceService = dataServices.getCommandPersistenceService();
        this.clusterPersistenceService = dataServices.getClusterPersistenceService();
        this.commandModelAssembler = entityModelAssemblers.getCommandModelAssembler();
        this.applicationModelAssembler = entityModelAssemblers.getApplicationModelAssembler();
        this.clusterModelAssembler = entityModelAssemblers.getClusterModelAssembler();
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createCommand(@RequestBody @Valid com.netflix.genie.common.dto.Command command) throws GenieException {
        log.info("Called to create new command {}", (Object)command);
        String id = this.commandPersistenceService.createCommand(DtoConverters.toV4CommandRequest((com.netflix.genie.common.dto.Command)command));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{id}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<com.netflix.genie.common.dto.Command> getCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called to get command with id {}", (Object)id);
        return this.commandModelAssembler.toModel(DtoConverters.toV3Command((Command)this.commandPersistenceService.getCommand(id)));
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedModel<EntityModel<com.netflix.genie.common.dto.Command>> getCommands(@RequestParam(value="name", required=false) @Nullable String name, @RequestParam(value="user", required=false) @Nullable String user, @RequestParam(value="status", required=false) @Nullable Set<String> statuses, @RequestParam(value="tag", required=false) @Nullable Set<String> tags, @PageableDefault(size=64, sort={"updated"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<com.netflix.genie.common.dto.Command> assembler) throws GenieException {
        Page commands;
        log.info("Called [name | user | status | tags | page]\n{} | {} | {} | {} | {}", new Object[]{name, user, statuses, tags, page});
        EnumSet<com.netflix.genie.common.external.dtos.v4.CommandStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(com.netflix.genie.common.external.dtos.v4.CommandStatus.class);
            for (String status : statuses) {
                enumStatuses.add(DtoConverters.toV4CommandStatus((CommandStatus)CommandStatus.parse((String)status)));
            }
        }
        if (tags != null && tags.stream().filter(tag -> tag.startsWith("genie.id:")).count() >= 1L) {
            ArrayList commandList = Lists.newArrayList();
            int prefixLength = "genie.id:".length();
            tags.stream().filter(tag -> tag.startsWith("genie.id:")).forEach(tag -> {
                String id = tag.substring(prefixLength);
                try {
                    commandList.add(DtoConverters.toV3Command((Command)this.commandPersistenceService.getCommand(id)));
                }
                catch (GenieException ge) {
                    log.debug("No command with id {} found", (Object)id, (Object)ge);
                }
            });
            commands = new PageImpl((List)commandList);
        } else if (tags != null && tags.stream().filter(tag -> tag.startsWith("genie.name:")).count() >= 1L) {
            Set<String> finalTags = tags.stream().filter(tag -> !tag.startsWith("genie.name:")).collect(Collectors.toSet());
            if (name == null) {
                Optional<String> finalName = tags.stream().filter(tag -> tag.startsWith("genie.name:")).map(tag -> tag.substring("genie.name:".length())).findFirst();
                commands = this.commandPersistenceService.getCommands(finalName.orElse(null), user, enumStatuses, finalTags, page).map(DtoConverters::toV3Command);
            } else {
                commands = this.commandPersistenceService.getCommands(name, user, enumStatuses, finalTags, page).map(DtoConverters::toV3Command);
            }
        } else {
            commands = this.commandPersistenceService.getCommands(name, user, enumStatuses, tags, page).map(DtoConverters::toV3Command);
        }
        Link self = WebMvcLinkBuilder.linkTo(((CommandRestController)WebMvcLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getCommands(name, user, statuses, tags, page, assembler)).withSelfRel();
        return assembler.toModel(commands, (RepresentationModelAssembler)this.commandModelAssembler, self);
    }

    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateCommand(@PathVariable(value="id") String id, @RequestBody com.netflix.genie.common.dto.Command updateCommand) throws GenieException {
        log.debug("Called to update command {}", (Object)updateCommand);
        this.commandPersistenceService.updateCommand(id, DtoConverters.toV4Command((com.netflix.genie.common.dto.Command)updateCommand));
    }

    @PatchMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchCommand(@PathVariable(value="id") String id, @RequestBody JsonPatch patch) throws GenieException {
        log.info("Called to patch command {} with patch {}", (Object)id, (Object)patch);
        com.netflix.genie.common.dto.Command currentCommand = DtoConverters.toV3Command((Command)this.commandPersistenceService.getCommand(id));
        try {
            log.debug("Will patch cluster {}. Original state: {}", (Object)id, (Object)currentCommand);
            JsonNode commandNode = GenieObjectMapper.getMapper().valueToTree((Object)currentCommand);
            JsonNode postPatchNode = patch.apply(commandNode);
            com.netflix.genie.common.dto.Command patchedCommand = (com.netflix.genie.common.dto.Command)GenieObjectMapper.getMapper().treeToValue((TreeNode)postPatchNode, com.netflix.genie.common.dto.Command.class);
            log.debug("Finished patching command {}. New state: {}", (Object)id, (Object)patchedCommand);
            this.commandPersistenceService.updateCommand(id, DtoConverters.toV4Command((com.netflix.genie.common.dto.Command)patchedCommand));
        }
        catch (JsonPatchException | IOException e) {
            log.error("Unable to patch command {} with patch {} due to exception.", new Object[]{id, patch, e});
            throw new GenieServerException(e.getLocalizedMessage(), e);
        }
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllCommands() throws GenieException {
        log.warn("Called to delete all commands.");
        this.commandPersistenceService.deleteAllCommands();
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called to delete command with id {}", (Object)id);
        this.commandPersistenceService.deleteCommand(id);
    }

    @PostMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addConfigsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.info("Called with id {} and config {}", (Object)id, configs);
        this.commandPersistenceService.addConfigsForCommand(id, configs);
    }

    @GetMapping(value={"/{id}/configs"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getConfigsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return this.commandPersistenceService.getConfigsForCommand(id);
    }

    @PutMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfigsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.info("Called with id {} and configs {}", (Object)id, configs);
        this.commandPersistenceService.updateConfigsForCommand(id, configs);
    }

    @DeleteMapping(value={"/{id}/configs"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllConfigsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.commandPersistenceService.removeAllConfigsForCommand(id);
    }

    @PostMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addDependenciesForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.info("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.commandPersistenceService.addDependenciesForCommand(id, dependencies);
    }

    @GetMapping(value={"/{id}/dependencies"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getDependenciesForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return this.commandPersistenceService.getDependenciesForCommand(id);
    }

    @PutMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDependenciesForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.info("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.commandPersistenceService.updateDependenciesForCommand(id, dependencies);
    }

    @DeleteMapping(value={"/{id}/dependencies"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllDependenciesForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.commandPersistenceService.removeAllDependenciesForCommand(id);
    }

    @PostMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addTagsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.info("Called with id {} and tags {}", (Object)id, tags);
        this.commandPersistenceService.addTagsForCommand(id, tags);
    }

    @GetMapping(value={"/{id}/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getTagsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return DtoConverters.toV3Command((Command)this.commandPersistenceService.getCommand(id)).getTags();
    }

    @PutMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTagsForCommand(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.info("Called with id {} and tags {}", (Object)id, tags);
        this.commandPersistenceService.updateTagsForCommand(id, tags);
    }

    @DeleteMapping(value={"/{id}/tags"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllTagsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.commandPersistenceService.removeAllTagsForCommand(id);
    }

    @DeleteMapping(value={"/{id}/tags/{tag}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeTagForCommand(@PathVariable(value="id") String id, @PathVariable(value="tag") String tag) throws GenieException {
        log.info("Called with id {} and tag {}", (Object)id, (Object)tag);
        this.commandPersistenceService.removeTagForCommand(id, tag);
    }

    @PostMapping(value={"/{id}/applications"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addApplicationsForCommand(@PathVariable(value="id") String id, @RequestBody List<String> applicationIds) throws GenieException {
        log.info("Called with id {} and application {}", (Object)id, applicationIds);
        this.commandPersistenceService.addApplicationsForCommand(id, applicationIds);
    }

    @GetMapping(value={"/{id}/applications"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<EntityModel<Application>> getApplicationsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return this.commandPersistenceService.getApplicationsForCommand(id).stream().map(DtoConverters::toV3Application).map(this.applicationModelAssembler::toModel).collect(Collectors.toList());
    }

    @PutMapping(value={"/{id}/applications"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setApplicationsForCommand(@PathVariable(value="id") String id, @RequestBody List<String> applicationIds) throws GenieException {
        log.info("Called with id {} and application {}", (Object)id, applicationIds);
        this.commandPersistenceService.setApplicationsForCommand(id, applicationIds);
    }

    @DeleteMapping(value={"/{id}/applications"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllApplicationsForCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id '{}'", (Object)id);
        this.commandPersistenceService.removeApplicationsForCommand(id);
    }

    @DeleteMapping(value={"/{id}/applications/{appId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeApplicationForCommand(@PathVariable(value="id") String id, @PathVariable(value="appId") String appId) throws GenieException {
        log.info("Called with id '{}' and app id {}", (Object)id, (Object)appId);
        this.commandPersistenceService.removeApplicationForCommand(id, appId);
    }

    @GetMapping(value={"/{id}/clusters"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<EntityModel<Cluster>> getClustersForCommand(@PathVariable(value="id") String id, @RequestParam(value="status", required=false) @Nullable Set<String> statuses) throws GenieException {
        log.info("Called with id {} and statuses {}", (Object)id, statuses);
        EnumSet<com.netflix.genie.common.external.dtos.v4.ClusterStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(com.netflix.genie.common.external.dtos.v4.ClusterStatus.class);
            for (String status : statuses) {
                enumStatuses.add(DtoConverters.toV4ClusterStatus((ClusterStatus)ClusterStatus.parse((String)status)));
            }
        }
        return this.commandPersistenceService.getClustersForCommand(id, enumStatuses).stream().map(DtoConverters::toV3Cluster).map(this.clusterModelAssembler::toModel).collect(Collectors.toSet());
    }

    @GetMapping(value={"/{id}/clusterCriteria"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<Criterion> getClusterCriteriaForCommand(@PathVariable(value="id") String id) throws GenieNotFoundException {
        log.info("Called for command {}", (Object)id);
        return this.commandPersistenceService.getClusterCriteriaForCommand(id);
    }

    @DeleteMapping(value={"/{id}/clusterCriteria"})
    @ResponseStatus(value=HttpStatus.OK)
    public void removeAllClusterCriteriaFromCommand(@PathVariable(value="id") String id) throws GenieNotFoundException {
        log.info("Called for command {}", (Object)id);
        this.commandPersistenceService.removeAllClusterCriteriaForCommand(id);
    }

    @PostMapping(value={"/{id}/clusterCriteria"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void addClusterCriterionForCommand(@PathVariable(value="id") String id, @RequestBody @Valid Criterion criterion) throws GenieNotFoundException {
        log.info("Called to add {} as the lowest priority cluster criterion for command {}", (Object)criterion, (Object)id);
        this.commandPersistenceService.addClusterCriterionForCommand(id, criterion);
    }

    @PutMapping(value={"/{id}/clusterCriteria"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void setClusterCriteriaForCommand(@PathVariable(value="id") String id, @RequestBody @Valid List<Criterion> clusterCriteria) throws GenieNotFoundException {
        log.info("Called to set {} as the cluster criteria for command {}", clusterCriteria, (Object)id);
        this.commandPersistenceService.setClusterCriteriaForCommand(id, clusterCriteria);
    }

    @PutMapping(value={"/{id}/clusterCriteria/{priority}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void insertClusterCriterionForCommand(@PathVariable(value="id") String id, @PathVariable(value="priority") @Min(value=0L) @Min(value=0L) int priority, @RequestBody @Valid Criterion criterion) throws GenieNotFoundException {
        log.info("Called to insert new criterion {} for command {} with priority {}", new Object[]{criterion, id, priority});
        this.commandPersistenceService.addClusterCriterionForCommand(id, criterion, priority);
    }

    @DeleteMapping(value={"/{id}/clusterCriteria/{priority}"})
    @ResponseStatus(value=HttpStatus.OK)
    public void removeClusterCriterionFromCommand(@PathVariable(value="id") String id, @PathVariable(value="priority") @Min(value=0L) @Min(value=0L) int priority) throws GenieNotFoundException {
        log.info("Called to remove the criterion from command {} with priority {}", (Object)id, (Object)priority);
        this.commandPersistenceService.removeClusterCriterionForCommand(id, priority);
    }

    @GetMapping(value={"/{id}/resolvedClusters"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<ResolvedResources<Cluster>> resolveClustersForCommandClusterCriteria(@PathVariable(value="id") String id, @RequestParam(value="addDefaultStatus", defaultValue="true") Boolean addDefaultStatus) throws GenieNotFoundException {
        log.info("Called to resolve clusters for command {}", (Object)id);
        List<Criterion> criteria = this.commandPersistenceService.getClusterCriteriaForCommand(id);
        ArrayList resolvedResources = Lists.newArrayList();
        for (Criterion criterion : criteria) {
            resolvedResources.add(new ResolvedResources(criterion, this.clusterPersistenceService.findClustersMatchingCriterion(criterion, addDefaultStatus).stream().map(DtoConverters::toV3Cluster).collect(Collectors.toSet())));
        }
        return resolvedResources;
    }
}

