/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.ApplicationRestController;
import javax.annotation.Nonnull;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class ApplicationModelAssembler
implements RepresentationModelAssembler<Application, EntityModel<Application>> {
    private static final String COMMANDS_LINK = "commands";

    @Nonnull
    public EntityModel<Application> toModel(Application application) {
        String id = (String)application.getId().orElseThrow(IllegalArgumentException::new);
        EntityModel applicationModel = new EntityModel((Object)application, new Link[0]);
        try {
            applicationModel.add(WebMvcLinkBuilder.linkTo(((ApplicationRestController)WebMvcLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getApplication(id)).withSelfRel());
            applicationModel.add(WebMvcLinkBuilder.linkTo(((ApplicationRestController)WebMvcLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getCommandsForApplication(id, null)).withRel(COMMANDS_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return applicationModel;
    }
}

