/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.entities;

import com.netflix.genie.web.data.entities.IdEntity;
import com.netflix.genie.web.data.entities.projections.AuditProjection;
import java.time.Instant;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Version;

@MappedSuperclass
public class AuditEntity
extends IdEntity
implements AuditProjection {
    @Basic(optional=false)
    @Column(name="created", nullable=false, updatable=false)
    private Instant created = Instant.now();
    @Basic(optional=false)
    @Column(name="updated", nullable=false)
    private Instant updated = Instant.now();
    @Version
    @Column(name="entity_version", nullable=false)
    private Integer entityVersion;

    @PrePersist
    protected void onCreateBaseEntity() {
        Instant now;
        this.updated = now = Instant.now();
        this.created = now;
    }

    @PreUpdate
    protected void onUpdateBaseEntity() {
        this.updated = Instant.now();
    }

    @Override
    public Instant getCreated() {
        return this.created;
    }

    @Override
    public Instant getUpdated() {
        return this.updated;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "AuditEntity(super=" + super.toString() + ", created=" + this.created + ", updated=" + this.updated + ")";
    }
}

