/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.entities;

import com.netflix.genie.web.data.entities.FileEntity;
import com.netflix.genie.web.data.entities.UniqueIdEntity;
import com.netflix.genie.web.data.entities.projections.BaseProjection;
import com.netflix.genie.web.data.entities.projections.SetupFileProjection;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

@MappedSuperclass
public class BaseEntity
extends UniqueIdEntity
implements BaseProjection,
SetupFileProjection {
    private static final long serialVersionUID = -5040659007494311180L;
    @Basic(optional=false)
    @Column(name="version", nullable=false)
    @NotBlank(message="Version is missing and is required.")
    @Size(max=255, message="Max length in database is 255 characters")
    private @NotBlank(message="Version is missing and is required.") @Size(max=255, message="Max length in database is 255 characters") String version;
    @Basic(optional=false)
    @Column(name="genie_user", nullable=false)
    @NotBlank(message="User name is missing and is required.")
    @Size(max=255, message="Max length in database is 255 characters")
    private @NotBlank(message="User name is missing and is required.") @Size(max=255, message="Max length in database is 255 characters") String user;
    @Basic(optional=false)
    @Column(name="name", nullable=false)
    @NotBlank(message="Name is missing and is required.")
    @Size(max=255, message="Max length in database is 255 characters")
    private @NotBlank(message="Name is missing and is required.") @Size(max=255, message="Max length in database is 255 characters") String name;
    @Basic(optional=false)
    @Column(name="status", nullable=false, length=20)
    private String status;
    @Basic
    @Column(name="description", length=1000)
    @Size(max=1000, message="Max length in database is 1000 characters")
    private @Size(max=1000, message="Max length in database is 1000 characters") String description;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="metadata", columnDefinition="TEXT DEFAULT NULL")
    private String metadata;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="setup_file")
    private FileEntity setupFile;

    BaseEntity() {
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Override
    public Optional<String> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    public void setMetadata(@Nullable String metadata) {
        this.metadata = metadata;
    }

    @Override
    public Optional<FileEntity> getSetupFile() {
        return Optional.ofNullable(this.setupFile);
    }

    public void setSetupFile(@Nullable FileEntity setupFile) {
        this.setupFile = setupFile;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "BaseEntity(super=" + super.toString() + ", version=" + this.version + ", user=" + this.user + ", name=" + this.name + ", status=" + this.status + ", description=" + this.description + ")";
    }
}

