/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services;

import com.github.fge.jsonpatch.JsonPatch;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.CommandRequest;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;

@Validated
public interface CommandPersistenceService {
    public String createCommand(@NotNull(message="No command entered. Unable to create.") @Valid @NotNull(message="No command entered. Unable to create.") @Valid CommandRequest var1) throws GenieException;

    public Command getCommand(@NotBlank(message="No id entered unable to get.") @NotBlank(message="No id entered unable to get.") String var1) throws GenieException;

    public Page<Command> getCommands(@Nullable String var1, @Nullable String var2, @Nullable Set<CommandStatus> var3, @Nullable Set<String> var4, Pageable var5);

    public void updateCommand(@NotBlank(message="No id entered. Unable to update.") @NotBlank(message="No id entered. Unable to update.") String var1, @NotNull(message="No command information entered. Unable to update.") @Valid @NotNull(message="No command information entered. Unable to update.") @Valid Command var2) throws GenieException;

    public void patchCommand(@NotBlank String var1, @NotNull JsonPatch var2) throws GenieException;

    public void deleteAllCommands() throws GenieException;

    public void deleteCommand(@NotBlank(message="No id entered. Unable to delete.") @NotBlank(message="No id entered. Unable to delete.") String var1) throws GenieException;

    public void addConfigsForCommand(@NotBlank(message="No command id entered. Unable to add configurations.") @NotBlank(message="No command id entered. Unable to add configurations.") String var1, @NotEmpty(message="No configuration files entered. Unable to add.") @NotEmpty(message="No configuration files entered. Unable to add.") Set<String> var2) throws GenieException;

    public Set<String> getConfigsForCommand(@NotBlank(message="No command id entered. Unable to get configs.") @NotBlank(message="No command id entered. Unable to get configs.") String var1) throws GenieException;

    public void updateConfigsForCommand(@NotBlank(message="No command id entered. Unable to update configurations.") @NotBlank(message="No command id entered. Unable to update configurations.") String var1, @NotEmpty(message="No configs entered. Unable to update.") @NotEmpty(message="No configs entered. Unable to update.") Set<String> var2) throws GenieException;

    public void removeAllConfigsForCommand(@NotBlank(message="No command id entered. Unable to remove configs.") @NotBlank(message="No command id entered. Unable to remove configs.") String var1) throws GenieException;

    public void removeConfigForCommand(@NotBlank(message="No command id entered. Unable to remove configuration.") @NotBlank(message="No command id entered. Unable to remove configuration.") String var1, @NotBlank(message="No config entered. Unable to remove.") @NotBlank(message="No config entered. Unable to remove.") String var2) throws GenieException;

    public void addDependenciesForCommand(@NotBlank(message="No command id entered. Unable to add dependencies.") @NotBlank(message="No command id entered. Unable to add dependencies.") String var1, @NotEmpty(message="No dependencies entered. Unable to add dependencies.") @NotEmpty(message="No dependencies entered. Unable to add dependencies.") Set<String> var2) throws GenieException;

    public Set<String> getDependenciesForCommand(@NotBlank(message="No command id entered. Unable to get dependencies.") @NotBlank(message="No command id entered. Unable to get dependencies.") String var1) throws GenieException;

    public void updateDependenciesForCommand(@NotBlank(message="No command id entered. Unable to update dependencies.") @NotBlank(message="No command id entered. Unable to update dependencies.") String var1, @NotNull(message="No dependencies entered. Unable to update.") @NotNull(message="No dependencies entered. Unable to update.") Set<String> var2) throws GenieException;

    public void removeAllDependenciesForCommand(@NotBlank(message="No command id entered. Unable to remove dependencies.") @NotBlank(message="No command id entered. Unable to remove dependencies.") String var1) throws GenieException;

    public void removeDependencyForCommand(@NotBlank(message="No command id entered. Unable to remove dependency.") @NotBlank(message="No command id entered. Unable to remove dependency.") String var1, @NotBlank(message="No dependency entered. Unable to remove dependency.") @NotBlank(message="No dependency entered. Unable to remove dependency.") String var2) throws GenieException;

    public void addTagsForCommand(@NotBlank(message="No command id entered. Unable to add tags.") @NotBlank(message="No command id entered. Unable to add tags.") String var1, @NotEmpty(message="No tags entered. Unable to add.") @NotEmpty(message="No tags entered. Unable to add.") Set<String> var2) throws GenieException;

    public Set<String> getTagsForCommand(@NotBlank(message="No command id sent. Cannot retrieve tags.") @NotBlank(message="No command id sent. Cannot retrieve tags.") String var1) throws GenieException;

    public void updateTagsForCommand(@NotBlank(message="No command id entered. Unable to update tags.") @NotBlank(message="No command id entered. Unable to update tags.") String var1, @NotEmpty(message="No tags entered. Unable to update.") @NotEmpty(message="No tags entered. Unable to update.") Set<String> var2) throws GenieException;

    public void removeAllTagsForCommand(@NotBlank(message="No command id entered. Unable to remove tags.") @NotBlank(message="No command id entered. Unable to remove tags.") String var1) throws GenieException;

    public void removeTagForCommand(@NotBlank(message="No command id entered. Unable to remove tag.") @NotBlank(message="No command id entered. Unable to remove tag.") String var1, @NotBlank(message="No tag entered. Unable to remove.") @NotBlank(message="No tag entered. Unable to remove.") String var2) throws GenieException;

    public void addApplicationsForCommand(@NotBlank(message="No command id entered. Unable to add applications.") @NotBlank(message="No command id entered. Unable to add applications.") String var1, @NotEmpty(message="No application ids entered. Unable to add applications.") @NotEmpty(message="No application ids entered. Unable to add applications.") List<String> var2) throws GenieException;

    public void setApplicationsForCommand(@NotBlank(message="No command id entered. Unable to set applications.") @NotBlank(message="No command id entered. Unable to set applications.") String var1, @NotNull(message="No application ids entered. Unable to set applications.") @NotNull(message="No application ids entered. Unable to set applications.") List<String> var2) throws GenieException;

    public List<Application> getApplicationsForCommand(@NotBlank(message="No command id entered. Unable to get applications.") @NotBlank(message="No command id entered. Unable to get applications.") String var1) throws GenieException;

    public void removeApplicationsForCommand(@NotBlank(message="No command id entered. Unable to remove applications.") @NotBlank(message="No command id entered. Unable to remove applications.") String var1) throws GenieException;

    public void removeApplicationForCommand(@NotBlank(message="No command id entered. Unable to remove application.") @NotBlank(message="No command id entered. Unable to remove application.") String var1, @NotBlank(message="No application id entered. Unable to remove application.") @NotBlank(message="No application id entered. Unable to remove application.") String var2) throws GenieException;

    public Set<Cluster> getClustersForCommand(@NotBlank(message="No command id entered. Unable to get clusters.") @NotBlank(message="No command id entered. Unable to get clusters.") String var1, @Nullable Set<ClusterStatus> var2) throws GenieException;

    public List<Criterion> getClusterCriteriaForCommand(String var1) throws GenieNotFoundException;

    public void addClusterCriterionForCommand(String var1, @Valid Criterion var2) throws GenieNotFoundException;

    public void addClusterCriterionForCommand(String var1, @Valid Criterion var2, @Min(value=0L) @Min(value=0L) int var3) throws GenieNotFoundException;

    public void setClusterCriteriaForCommand(String var1, List<@Valid Criterion> var2) throws GenieNotFoundException;

    public void removeClusterCriterionForCommand(String var1, @Min(value=0L) @Min(value=0L) int var2) throws GenieNotFoundException;

    public void removeAllClusterCriteriaForCommand(String var1) throws GenieNotFoundException;

    public Set<Command> findCommandsMatchingCriterion(@Valid Criterion var1, boolean var2);

    public int updateStatusForUnusedCommands(CommandStatus var1, Instant var2, Set<CommandStatus> var3, Instant var4);

    public long deleteUnusedCommands(Set<CommandStatus> var1, Instant var2);
}

