/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.jpa;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieBadRequestException;
import com.netflix.genie.common.exceptions.GenieConflictException;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.CommandMetadata;
import com.netflix.genie.common.external.dtos.v4.CommandRequest;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.ExecutionEnvironment;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.data.entities.ApplicationEntity;
import com.netflix.genie.web.data.entities.ClusterEntity;
import com.netflix.genie.web.data.entities.CommandEntity;
import com.netflix.genie.web.data.entities.CriterionEntity;
import com.netflix.genie.web.data.entities.FileEntity;
import com.netflix.genie.web.data.entities.TagEntity;
import com.netflix.genie.web.data.entities.v4.EntityDtoConverters;
import com.netflix.genie.web.data.repositories.jpa.JpaApplicationRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaClusterRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaCommandRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaCriterionRepository;
import com.netflix.genie.web.data.repositories.jpa.specifications.JpaClusterSpecs;
import com.netflix.genie.web.data.repositories.jpa.specifications.JpaCommandSpecs;
import com.netflix.genie.web.data.services.CommandPersistenceService;
import com.netflix.genie.web.data.services.jpa.JpaBaseService;
import com.netflix.genie.web.data.services.jpa.JpaFilePersistenceService;
import com.netflix.genie.web.data.services.jpa.JpaTagPersistenceService;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={GenieException.class, GenieRuntimeException.class, ConstraintViolationException.class})
public class JpaCommandPersistenceServiceImpl
extends JpaBaseService
implements CommandPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaCommandPersistenceServiceImpl.class);

    public JpaCommandPersistenceServiceImpl(JpaTagPersistenceService tagPersistenceService, JpaFilePersistenceService filePersistenceService, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository, JpaCriterionRepository criterionRepository) {
        super(tagPersistenceService, filePersistenceService, applicationRepository, clusterRepository, commandRepository, criterionRepository);
    }

    @Override
    public String createCommand(@NotNull(message="No command entered. Unable to create.") @Valid @NotNull(message="No command entered. Unable to create.") @Valid CommandRequest request) throws GenieException {
        log.debug("Called to create command {}", (Object)request);
        CommandEntity commandEntity = this.createCommandEntity(request);
        try {
            this.getCommandRepository().save(commandEntity);
        }
        catch (DataIntegrityViolationException e) {
            throw new GenieConflictException("A command with id " + commandEntity.getUniqueId() + " already exists", (Throwable)e);
        }
        return commandEntity.getUniqueId();
    }

    @Override
    @Transactional(readOnly=true)
    public Command getCommand(@NotBlank(message="No id entered unable to get.") @NotBlank(message="No id entered unable to get.") String id) throws GenieException {
        log.debug("called");
        return EntityDtoConverters.toV4CommandDto(this.findCommand(id));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Command> getCommands(@Nullable String name, @Nullable String user, @Nullable Set<CommandStatus> statuses, @Nullable Set<String> tags, Pageable page) {
        Set<TagEntity> tagEntities;
        log.debug("Called");
        if (tags != null) {
            tagEntities = this.getTagPersistenceService().getTags(tags);
            if (tagEntities.size() != tags.size()) {
                return new PageImpl(new ArrayList(), page, 0L);
            }
        } else {
            tagEntities = null;
        }
        Page commandEntities = this.getCommandRepository().findAll(JpaCommandSpecs.find(name, user, statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null, tagEntities), page);
        return commandEntities.map(EntityDtoConverters::toV4CommandDto);
    }

    @Override
    public void updateCommand(@NotBlank(message="No id entered. Unable to update.") @NotBlank(message="No id entered. Unable to update.") String id, @NotNull(message="No command information entered. Unable to update.") @Valid @NotNull(message="No command information entered. Unable to update.") @Valid Command updateCommand) throws GenieException {
        if (!this.getCommandRepository().existsByUniqueId(id)) {
            throw new GenieNotFoundException("No command exists with the given id. Unable to update.");
        }
        String updateId = updateCommand.getId();
        if (!id.equals(updateId)) {
            throw new GenieBadRequestException("Command id inconsistent with id passed in.");
        }
        log.debug("Called to update command with id {} {}", (Object)id, (Object)updateCommand);
        this.updateEntityWithDtoContents(this.findCommand(id), updateCommand);
    }

    @Override
    public void patchCommand(@NotBlank String id, @NotNull JsonPatch patch) throws GenieException {
        CommandEntity commandEntity = this.findCommand(id);
        try {
            Command commandToPatch = EntityDtoConverters.toV4CommandDto(commandEntity);
            log.debug("Will patch command {}. Original state: {}", (Object)id, (Object)commandToPatch);
            JsonNode commandNode = GenieObjectMapper.getMapper().valueToTree((Object)commandToPatch);
            JsonNode postPatchNode = patch.apply(commandNode);
            Command patchedCommand = (Command)GenieObjectMapper.getMapper().treeToValue((TreeNode)postPatchNode, Command.class);
            log.debug("Finished patching command {}. New state: {}", (Object)id, (Object)patchedCommand);
            this.updateEntityWithDtoContents(commandEntity, patchedCommand);
        }
        catch (JsonPatchException | IOException e) {
            log.error("Unable to patch cluster {} with patch {} due to exception.", new Object[]{id, patch, e});
            throw new GenieServerException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void deleteAllCommands() throws GenieException {
        log.debug("Called to delete all commands");
        for (CommandEntity commandEntity : this.getCommandRepository().findAll()) {
            this.deleteCommand(commandEntity.getUniqueId());
        }
    }

    @Override
    public void deleteCommand(@NotBlank(message="No id entered. Unable to delete.") @NotBlank(message="No id entered. Unable to delete.") String id) throws GenieException {
        Set<ClusterEntity> originalClusters;
        log.debug("Called to delete command config with id {}", (Object)id);
        CommandEntity commandEntity = this.findCommand(id);
        List<ApplicationEntity> originalApps = commandEntity.getApplications();
        if (originalApps != null) {
            ArrayList applicationEntities = Lists.newArrayList(originalApps);
            applicationEntities.forEach(commandEntity::removeApplication);
        }
        if ((originalClusters = commandEntity.getClusters()) != null) {
            HashSet clusterEntities = Sets.newHashSet(originalClusters);
            clusterEntities.forEach(clusterEntity -> clusterEntity.removeCommand(commandEntity));
        }
        this.getCommandRepository().delete(commandEntity);
    }

    @Override
    public void addConfigsForCommand(@NotBlank(message="No command id entered. Unable to add configurations.") @NotBlank(message="No command id entered. Unable to add configurations.") String id, @NotEmpty(message="No configuration files entered. Unable to add.") @NotEmpty(message="No configuration files entered. Unable to add.") Set<String> configs) throws GenieException {
        this.findCommand(id).getConfigs().addAll(this.createAndGetFileEntities(configs));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getConfigsForCommand(@NotBlank(message="No command id entered. Unable to get configs.") @NotBlank(message="No command id entered. Unable to get configs.") String id) throws GenieException {
        return this.findCommand(id).getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public void updateConfigsForCommand(@NotBlank(message="No command id entered. Unable to update configurations.") @NotBlank(message="No command id entered. Unable to update configurations.") String id, @NotEmpty(message="No configs entered. Unable to update.") @NotEmpty(message="No configs entered. Unable to update.") Set<String> configs) throws GenieException {
        this.findCommand(id).setConfigs(this.createAndGetFileEntities(configs));
    }

    @Override
    public void removeAllConfigsForCommand(@NotBlank(message="No command id entered. Unable to remove configs.") @NotBlank(message="No command id entered. Unable to remove configs.") String id) throws GenieException {
        this.findCommand(id).getConfigs().clear();
    }

    @Override
    public void removeConfigForCommand(@NotBlank(message="No command id entered. Unable to remove configuration.") @NotBlank(message="No command id entered. Unable to remove configuration.") String id, @NotBlank(message="No config entered. Unable to remove.") @NotBlank(message="No config entered. Unable to remove.") String config) throws GenieException {
        this.getFilePersistenceService().getFile(config).ifPresent(this.findCommand(id).getConfigs()::remove);
    }

    @Override
    public void addDependenciesForCommand(@NotBlank(message="No command id entered. Unable to add dependencies.") @NotBlank(message="No command id entered. Unable to add dependencies.") String id, @NotEmpty(message="No dependencies entered. Unable to add dependencies.") @NotEmpty(message="No dependencies entered. Unable to add dependencies.") Set<String> dependencies) throws GenieException {
        this.findCommand(id).getDependencies().addAll(this.createAndGetFileEntities(dependencies));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getDependenciesForCommand(@NotBlank(message="No command id entered. Unable to get dependencies.") @NotBlank(message="No command id entered. Unable to get dependencies.") String id) throws GenieException {
        return this.findCommand(id).getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public void updateDependenciesForCommand(@NotBlank(message="No command id entered. Unable to update dependencies.") @NotBlank(message="No command id entered. Unable to update dependencies.") String id, @NotNull(message="No dependencies entered. Unable to update.") @NotNull(message="No dependencies entered. Unable to update.") Set<String> dependencies) throws GenieException {
        this.findCommand(id).setDependencies(this.createAndGetFileEntities(dependencies));
    }

    @Override
    public void removeAllDependenciesForCommand(@NotBlank(message="No command id entered. Unable to remove dependencies.") @NotBlank(message="No command id entered. Unable to remove dependencies.") String id) throws GenieException {
        this.findCommand(id).getDependencies().clear();
    }

    @Override
    public void removeDependencyForCommand(@NotBlank(message="No command id entered. Unable to remove dependency.") @NotBlank(message="No command id entered. Unable to remove dependency.") String id, @NotBlank(message="No dependency entered. Unable to remove dependency.") @NotBlank(message="No dependency entered. Unable to remove dependency.") String dependency) throws GenieException {
        this.getFilePersistenceService().getFile(dependency).ifPresent(this.findCommand(id).getDependencies()::remove);
    }

    @Override
    public void addTagsForCommand(@NotBlank(message="No command id entered. Unable to add tags.") @NotBlank(message="No command id entered. Unable to add tags.") String id, @NotEmpty(message="No tags entered. Unable to add.") @NotEmpty(message="No tags entered. Unable to add.") Set<String> tags) throws GenieException {
        this.findCommand(id).getTags().addAll(this.createAndGetTagEntities(tags));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getTagsForCommand(@NotBlank(message="No command id sent. Cannot retrieve tags.") @NotBlank(message="No command id sent. Cannot retrieve tags.") String id) throws GenieException {
        return this.findCommand(id).getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet());
    }

    @Override
    public void updateTagsForCommand(@NotBlank(message="No command id entered. Unable to update tags.") @NotBlank(message="No command id entered. Unable to update tags.") String id, @NotEmpty(message="No tags entered. Unable to update.") @NotEmpty(message="No tags entered. Unable to update.") Set<String> tags) throws GenieException {
        this.findCommand(id).setTags(this.createAndGetTagEntities(tags));
    }

    @Override
    public void removeAllTagsForCommand(@NotBlank(message="No command id entered. Unable to remove tags.") @NotBlank(message="No command id entered. Unable to remove tags.") String id) throws GenieException {
        this.findCommand(id).getTags().clear();
    }

    @Override
    public void removeTagForCommand(@NotBlank(message="No command id entered. Unable to remove tag.") @NotBlank(message="No command id entered. Unable to remove tag.") String id, @NotBlank(message="No tag entered. Unable to remove.") @NotBlank(message="No tag entered. Unable to remove.") String tag) throws GenieException {
        this.getTagPersistenceService().getTag(tag).ifPresent(this.findCommand(id).getTags()::remove);
    }

    @Override
    public void addApplicationsForCommand(@NotBlank(message="No command id entered. Unable to add applications.") @NotBlank(message="No command id entered. Unable to add applications.") String id, @NotEmpty(message="No application ids entered. Unable to add applications.") @NotEmpty(message="No application ids entered. Unable to add applications.") List<String> applicationIds) throws GenieException {
        if ((long)applicationIds.size() != applicationIds.stream().filter(this.getApplicationRepository()::existsByUniqueId).count()) {
            throw new GeniePreconditionException("All applications need to exist to add to a command");
        }
        CommandEntity commandEntity = this.findCommand(id);
        for (String appId : applicationIds) {
            commandEntity.addApplication(this.getApplicationEntity(appId).orElseThrow(() -> new GenieNotFoundException("No application with id " + appId + " found")));
        }
    }

    @Override
    public void setApplicationsForCommand(@NotBlank(message="No command id entered. Unable to set applications.") @NotBlank(message="No command id entered. Unable to set applications.") String id, @NotNull(message="No application ids entered. Unable to set applications.") @NotNull(message="No application ids entered. Unable to set applications.") List<String> applicationIds) throws GenieException {
        if ((long)applicationIds.size() != applicationIds.stream().filter(this.getApplicationRepository()::existsByUniqueId).count()) {
            throw new GeniePreconditionException("All applications need to exist to add to a command");
        }
        CommandEntity commandEntity = this.findCommand(id);
        ArrayList<ApplicationEntity> applicationEntities = new ArrayList<ApplicationEntity>();
        for (String appId : applicationIds) {
            applicationEntities.add(this.getApplicationEntity(appId).orElseThrow(() -> new GenieNotFoundException("Couldn't find application with unique id " + appId)));
        }
        commandEntity.setApplications(applicationEntities);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Application> getApplicationsForCommand(@NotBlank(message="No command id entered. Unable to get applications.") @NotBlank(message="No command id entered. Unable to get applications.") String id) throws GenieException {
        CommandEntity commandEntity = this.findCommand(id);
        return commandEntity.getApplications().stream().map(EntityDtoConverters::toV4ApplicationDto).collect(Collectors.toList());
    }

    @Override
    public void removeApplicationsForCommand(@NotBlank(message="No command id entered. Unable to remove applications.") @NotBlank(message="No command id entered. Unable to remove applications.") String id) throws GenieException {
        this.findCommand(id).setApplications(null);
    }

    @Override
    public void removeApplicationForCommand(@NotBlank(message="No command id entered. Unable to remove application.") @NotBlank(message="No command id entered. Unable to remove application.") String id, @NotBlank(message="No application id entered. Unable to remove application.") @NotBlank(message="No application id entered. Unable to remove application.") String appId) throws GenieException {
        this.getApplicationRepository().findByUniqueId(appId).ifPresent(this.findCommand(id).getApplications()::remove);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<Cluster> getClustersForCommand(@NotBlank(message="No command id entered. Unable to get clusters.") @NotBlank(message="No command id entered. Unable to get clusters.") String id, @Nullable Set<ClusterStatus> statuses) throws GenieException {
        if (!this.getCommandRepository().existsByUniqueId(id)) {
            throw new GenieNotFoundException("No command with id " + id + " exists.");
        }
        return this.getClusterRepository().findAll(JpaClusterSpecs.findClustersForCommand(id, statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null)).stream().map(EntityDtoConverters::toV4ClusterDto).collect(Collectors.toSet());
    }

    @Override
    @Transactional(readOnly=true)
    public List<Criterion> getClusterCriteriaForCommand(String id) throws GenieNotFoundException {
        log.debug("[getClusterCriteriaForCommand] Called to get cluster criteria for command {}", (Object)id);
        CommandEntity commandEntity = this.findCommand(id);
        return commandEntity.getClusterCriteria().stream().map(EntityDtoConverters::toCriterionDto).collect(Collectors.toList());
    }

    @Override
    public void addClusterCriterionForCommand(String id, @Valid Criterion criterion) throws GenieNotFoundException {
        log.debug("[addClusterCriterionForCommand] Called to add cluster criteria {} for command {}", (Object)criterion, (Object)id);
        CommandEntity commandEntity = this.findCommand(id);
        commandEntity.addClusterCriterion(this.toCriterionEntity(criterion));
    }

    @Override
    public void addClusterCriterionForCommand(String id, @Valid Criterion criterion, @Min(value=0L) @Min(value=0L) int priority) throws GenieNotFoundException {
        log.debug("[addClusterCriterionForCommand] Called to add cluster criteria {} for command {} at priority {}", new Object[]{criterion, id, priority});
        CommandEntity commandEntity = this.findCommand(id);
        commandEntity.addClusterCriterion(this.toCriterionEntity(criterion), priority);
    }

    @Override
    public void setClusterCriteriaForCommand(String id, List<@Valid Criterion> clusterCriteria) throws GenieNotFoundException {
        log.debug("[setClusterCriteriaForCommand] Called to set cluster criteria {} for command {}", clusterCriteria, (Object)id);
        CommandEntity commandEntity = this.findCommand(id);
        this.updateClusterCriteria(commandEntity, clusterCriteria);
    }

    @Override
    public void removeClusterCriterionForCommand(String id, @Min(value=0L) @Min(value=0L) int priority) throws GenieNotFoundException {
        log.debug("[removeClusterCriterionForCommand] Called to remove cluster criterion with priority {} from command {}", (Object)priority, (Object)id);
        CommandEntity commandEntity = this.findCommand(id);
        if (priority >= commandEntity.getClusterCriteria().size()) {
            throw new GenieNotFoundException("No criterion with priority " + priority + " exists for command " + id + ". Unable to remove.");
        }
        try {
            CriterionEntity criterionEntity = commandEntity.removeClusterCriterion(priority);
            log.debug("Successfully removed cluster criterion {} from command {}", (Object)criterionEntity, (Object)id);
            this.getCriterionRepository().delete(criterionEntity);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to remove cluster criterion with priority {} from command {}", new Object[]{priority, id, e});
        }
    }

    @Override
    public void removeAllClusterCriteriaForCommand(String id) throws GenieNotFoundException {
        log.debug("[removeAllClusterCriteriaForCommand] Called to remove all cluster criteria from command {}", (Object)id);
        this.deleteAllClusterCriteria(this.findCommand(id));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<Command> findCommandsMatchingCriterion(@Valid Criterion criterion, boolean addDefaultStatus) {
        Criterion finalCriterion = addDefaultStatus && !criterion.getStatus().isPresent() ? new Criterion(criterion, CommandStatus.ACTIVE.name()) : criterion;
        log.debug("[findCommandsMatchingCriterion] Called to find commands matching {}", (Object)finalCriterion);
        return this.getCommandRepository().findAll(JpaCommandSpecs.findCommandsMatchingCriterion(finalCriterion)).stream().map(EntityDtoConverters::toV4CommandDto).collect(Collectors.toSet());
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public int updateStatusForUnusedCommands(CommandStatus desiredStatus, Instant commandCreatedThreshold, Set<CommandStatus> currentStatuses, Instant jobCreatedThreshold) {
        log.info("Updating any commands with statuses {} that were created before {} and haven't been used in jobs created after {} to new status {}", new Object[]{currentStatuses, commandCreatedThreshold, jobCreatedThreshold, desiredStatus});
        return this.getCommandRepository().setUnusedStatus(desiredStatus.name(), commandCreatedThreshold, currentStatuses.stream().map(Enum::name).collect(Collectors.toSet()), jobCreatedThreshold);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public long deleteUnusedCommands(Set<CommandStatus> deleteStatuses, Instant commandCreatedThreshold) {
        log.info("Deleting commands with statuses {} that were created before {}", deleteStatuses, (Object)commandCreatedThreshold);
        return this.getCommandRepository().deleteByIdIn(this.getCommandRepository().findUnusedCommands(deleteStatuses.stream().map(Enum::name).collect(Collectors.toSet()), commandCreatedThreshold));
    }

    private CommandEntity findCommand(String id) throws GenieNotFoundException {
        return (CommandEntity)this.getCommandRepository().findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No command with id " + id + " exists."));
    }

    private CommandEntity createCommandEntity(CommandRequest request) {
        ExecutionEnvironment resources = request.getResources();
        CommandMetadata metadata = request.getMetadata();
        CommandEntity entity = new CommandEntity();
        this.setUniqueId(entity, request.getRequestedId().orElse(null));
        entity.setCheckDelay(request.getCheckDelay().orElse(10000L));
        entity.setExecutable(request.getExecutable());
        request.getMemory().ifPresent(entity::setMemory);
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies, entity::setSetupFile);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setEntityCommandMetadata(entity, metadata);
        request.getClusterCriteria().stream().map(this::toCriterionEntity).forEach(entity::addClusterCriterion);
        return entity;
    }

    private void updateEntityWithDtoContents(CommandEntity entity, Command dto) {
        ExecutionEnvironment resources = dto.getResources();
        CommandMetadata metadata = dto.getMetadata();
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies, entity::setSetupFile);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setEntityCommandMetadata(entity, metadata);
        entity.setCheckDelay(dto.getCheckDelay());
        entity.setExecutable(dto.getExecutable());
        entity.setMemory(dto.getMemory().orElse(null));
        this.updateClusterCriteria(entity, dto.getClusterCriteria());
    }

    private void setEntityCommandMetadata(CommandEntity entity, CommandMetadata metadata) {
        entity.setName(metadata.getName());
        entity.setUser(metadata.getUser());
        entity.setVersion(metadata.getVersion());
        entity.setDescription(metadata.getDescription().orElse(null));
        entity.setStatus(metadata.getStatus().name());
        EntityDtoConverters.setJsonField(metadata.getMetadata().orElse(null), entity::setMetadata);
    }

    private void updateClusterCriteria(CommandEntity commandEntity, List<Criterion> clusterCriteria) {
        this.deleteAllClusterCriteria(commandEntity);
        commandEntity.setClusterCriteria(clusterCriteria.stream().map(this::toCriterionEntity).collect(Collectors.toList()));
    }

    private void deleteAllClusterCriteria(CommandEntity commandEntity) {
        List<CriterionEntity> persistedEntities = commandEntity.getClusterCriteria();
        ArrayList entitiesToDelete = Lists.newArrayList(persistedEntities);
        persistedEntities.clear();
        entitiesToDelete.forEach(criterionEntity -> this.getCriterionRepository().delete(criterionEntity));
    }
}

