/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.events;

import com.amazonaws.services.sns.AmazonSNS;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.genie.web.properties.SNSNotificationsProperties;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSNSPublisher {
    private static final Logger log = LoggerFactory.getLogger(AbstractSNSPublisher.class);
    private static final String PUBLISH_METRIC_COUNTER_NAME_FORMAT = "genie.notifications.sns.publish.counter";
    private static final String EVENT_TYPE_METRIC_TAG_NAME = "type";
    private static final String EVENT_TYPE_KEY_NAME = "type";
    private static final String EVENT_ID_KEY_NAME = "id";
    private static final String EVENT_TIMESTAMP_KEY_NAME = "timestamp";
    private static final String EVENT_ISO_TIMESTAMP_KEY_NAME = "isoTimestamp";
    private static final String EVENT_DETAILS_KEY_NAME = "details";
    protected final SNSNotificationsProperties properties;
    protected final MeterRegistry registry;
    private final AmazonSNS snsClient;
    private final ObjectMapper mapper;

    AbstractSNSPublisher(SNSNotificationsProperties properties, MeterRegistry registry, AmazonSNS snsClient, ObjectMapper mapper) {
        this.properties = properties;
        this.registry = registry;
        this.snsClient = snsClient;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishEvent(EventType eventType, HashMap<String, Object> eventDetailsMap) {
        String topic = this.properties.getTopicARN();
        if (StringUtils.isBlank((CharSequence)topic)) {
            log.warn("SNS Notifications enabled, but no topic specified");
            return;
        }
        HashMap eventMap = Maps.newHashMap();
        eventMap.putAll(this.properties.getAdditionalEventKeys());
        eventMap.put("type", eventType.name());
        eventMap.put(EVENT_ID_KEY_NAME, UUID.randomUUID().toString());
        Instant timestamp = Instant.now();
        eventMap.put(EVENT_TIMESTAMP_KEY_NAME, timestamp.toEpochMilli());
        eventMap.put(EVENT_ISO_TIMESTAMP_KEY_NAME, timestamp);
        eventMap.put(EVENT_DETAILS_KEY_NAME, eventDetailsMap);
        HashSet metricTags = Sets.newHashSet((Object[])new Tag[]{eventType.getTypeTag()});
        try {
            String serializedMessage = this.mapper.writeValueAsString((Object)eventMap);
            this.snsClient.publish(topic, serializedMessage);
            log.debug("Published SNS notification (type: {})", (Object)eventType.name());
            metricTags.addAll(MetricsUtils.newSuccessTagsSet());
        }
        catch (JsonProcessingException | RuntimeException e) {
            metricTags.addAll(MetricsUtils.newFailureTagsSetForException(e));
            log.error("Failed to publish SNS notification", e);
        }
        finally {
            this.registry.counter(PUBLISH_METRIC_COUNTER_NAME_FORMAT, (Iterable)metricTags).increment();
        }
    }

    protected static enum EventType {
        JOB_STATUS_CHANGE,
        JOB_FINISHED;

        private final Tag typeTag = Tag.of((String)"type", (String)this.name());

        protected Tag getTypeTag() {
            return this.typeTag;
        }
    }
}

