/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.internal.services.JobDirectoryManifestCreatorService;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.impl.GenieBaseTask;
import com.netflix.genie.web.util.MetricsUtils;
import com.netflix.genie.web.util.UNIXUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.support.RetryTemplate;

public class JobKickoffTask
extends GenieBaseTask {
    private static final Logger log = LoggerFactory.getLogger(JobKickoffTask.class);
    private static final String JOB_KICKOFF_TASK_TIMER_NAME = "genie.jobs.tasks.jobKickoffTask.timer";
    private final boolean isRunAsUserEnabled;
    private final boolean isUserCreationEnabled;
    private final Executor executor;
    private final String hostname;
    private final RetryTemplate retryTemplate;
    private final JobDirectoryManifestCreatorService jobDirectoryManifestCreatorService;

    public JobKickoffTask(boolean runAsUserEnabled, boolean userCreationEnabled, @NotNull Executor executor, @NotNull String hostname, @NotNull MeterRegistry registry, JobDirectoryManifestCreatorService jobDirectoryManifestCreatorService) {
        super(registry);
        this.isRunAsUserEnabled = runAsUserEnabled;
        this.isUserCreationEnabled = userCreationEnabled;
        this.executor = executor;
        this.hostname = hostname;
        this.jobDirectoryManifestCreatorService = jobDirectoryManifestCreatorService;
        this.retryTemplate = new RetryTemplate();
        this.retryTemplate.setBackOffPolicy((BackOffPolicy)new ExponentialBackOffPolicy());
    }

    @Override
    public void executeTask(@NotNull Map<String, Object> context) throws GenieException, IOException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            JobExecutionEnvironment jobExecEnv = (JobExecutionEnvironment)context.get("jee");
            String jobWorkingDirectory = jobExecEnv.getJobWorkingDir().getCanonicalPath();
            JobRequest jobRequest = jobExecEnv.getJobRequest();
            String user = jobRequest.getUser();
            Writer writer = (Writer)context.get("writer");
            String jobId = (String)jobRequest.getId().orElseThrow(() -> new GeniePreconditionException("No job id found. Unable to continue."));
            log.info("Starting Job Kickoff Task for job {}", (Object)jobId);
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                throw new GenieServerException("Failed to execute job", (Throwable)e);
            }
            if (this.isUserCreationEnabled) {
                try {
                    UNIXUtils.createUser(user, jobRequest.getGroup().orElse(null), this.executor);
                }
                catch (IOException ioexception) {
                    throw new GenieServerException("Could not create user " + user, (Throwable)ioexception);
                }
            }
            ArrayList<String> command = new ArrayList<String>();
            if (SystemUtils.IS_OS_LINUX) {
                command.add("setsid");
            }
            if (this.isRunAsUserEnabled) {
                try {
                    UNIXUtils.changeOwnershipOfDirectory(jobWorkingDirectory, user, this.executor);
                }
                catch (IOException ioexception) {
                    throw new GenieServerException("Could not change ownership", (Throwable)ioexception);
                }
                try {
                    UNIXUtils.makeDirGroupWritable(jobWorkingDirectory + "/genie/logs", this.executor);
                }
                catch (IOException e) {
                    throw new GenieServerException("Could not make the job working logs directory group writable.", (Throwable)e);
                }
                command.add("sudo");
                command.add("-u");
                command.add(user);
            }
            command.add("bash");
            String runScript = jobWorkingDirectory + "/" + "run";
            command.add(runScript);
            ProcessBuilder pb = new ProcessBuilder(command).directory(jobExecEnv.getJobWorkingDir()).redirectOutput(new File(jobExecEnv.getJobWorkingDir() + "/genie/logs/genie.log")).redirectError(new File(jobExecEnv.getJobWorkingDir() + "/genie/logs/genie.log"));
            this.jobDirectoryManifestCreatorService.invalidateCachedDirectoryManifest(jobExecEnv.getJobWorkingDir().toPath());
            try {
                Process process = pb.start();
                int processId = this.getProcessId(process);
                Instant timeout = Instant.now().plus((long)jobRequest.getTimeout().orElse(604800).intValue(), ChronoUnit.SECONDS);
                JobExecution jobExecution = ((JobExecution.Builder)new JobExecution.Builder(this.hostname).withId(jobId)).withProcessId(Integer.valueOf(processId)).withCheckDelay(Long.valueOf(jobExecEnv.getCommand().getCheckDelay())).withTimeout(timeout).withMemory(Integer.valueOf(jobExecEnv.getMemory())).build();
                context.put("jexecdto", jobExecution);
            }
            catch (IOException ie) {
                throw new GenieServerException("Unable to start command " + command, (Throwable)ie);
            }
            log.info("Finished Job Kickoff Task for job {}", (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.getRegistry().timer(JOB_KICKOFF_TASK_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private int getProcessId(Process proc) throws GenieException {
        log.debug("called");
        try {
            Field f = proc.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            return f.getInt(proc);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            String msg = "Can't get process id for job";
            log.error("Can't get process id for job", (Throwable)e);
            throw new GenieServerException("Can't get process id for job", (Throwable)e);
        }
    }
}

