/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.retry")
@Validated
public class RetryProperties {
    public static final String PROPERTY_PREFIX = "genie.retry";
    @Min(value=1L)
    private @Min(value=1L) int noOfRetries = 5;
    @Min(value=1L)
    private @Min(value=1L) long initialInterval = 10000L;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFFFFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFFFFFFFFFL) long maxInterval = 60000L;
    @Valid
    private ServiceSpecificProperties s3 = new ServiceSpecificProperties();
    @Valid
    private ServiceSpecificProperties sns = new ServiceSpecificProperties();

    public int getNoOfRetries() {
        return this.noOfRetries;
    }

    public long getInitialInterval() {
        return this.initialInterval;
    }

    public long getMaxInterval() {
        return this.maxInterval;
    }

    public ServiceSpecificProperties getS3() {
        return this.s3;
    }

    public ServiceSpecificProperties getSns() {
        return this.sns;
    }

    public void setNoOfRetries(int noOfRetries) {
        this.noOfRetries = noOfRetries;
    }

    public void setInitialInterval(long initialInterval) {
        this.initialInterval = initialInterval;
    }

    public void setMaxInterval(long maxInterval) {
        this.maxInterval = maxInterval;
    }

    public void setS3(ServiceSpecificProperties s3) {
        this.s3 = s3;
    }

    public void setSns(ServiceSpecificProperties sns) {
        this.sns = sns;
    }

    @Validated
    public static class ServiceSpecificProperties {
        @Min(value=1L)
        private @Min(value=1L) int noOfRetries = 5;

        public int getNoOfRetries() {
            return this.noOfRetries;
        }

        public void setNoOfRetries(int noOfRetries) {
            this.noOfRetries = noOfRetries;
        }
    }
}

