/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.properties.ClusterSelectorScriptProperties;
import com.netflix.genie.web.scripts.ResourceSelectorScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.scripts.ScriptManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSelectorManagedScript
extends ResourceSelectorScript<Cluster> {
    private static final Logger log = LoggerFactory.getLogger(ClusterSelectorManagedScript.class);
    static final String CLUSTERS_BINDING = "clustersParameter";

    public ClusterSelectorManagedScript(ScriptManager scriptManager, ClusterSelectorScriptProperties properties, MeterRegistry registry) {
        super(scriptManager, properties, registry);
    }

    @Override
    public ResourceSelectorScriptResult<Cluster> selectResource(Set<Cluster> resources, JobRequest jobRequest, String jobId) throws ResourceSelectionException {
        log.debug("Called to attempt to select a cluster from {} for job {}", resources, (Object)jobId);
        return super.selectResource(resources, jobRequest, jobId);
    }

    @Override
    protected void addParametersForScript(Map<String, Object> parameters, Set<Cluster> resources, JobRequest jobRequest) {
        super.addParametersForScript(parameters, resources, jobRequest);
        parameters.put(CLUSTERS_BINDING, resources);
    }
}

