/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.properties.CommandSelectorManagedScriptProperties;
import com.netflix.genie.web.scripts.ResourceSelectorScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.scripts.ScriptManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSelectorManagedScript
extends ResourceSelectorScript<Command> {
    private static final Logger log = LoggerFactory.getLogger(CommandSelectorManagedScript.class);
    static final String COMMANDS_BINDING = "commandsParameter";

    public CommandSelectorManagedScript(ScriptManager scriptManager, CommandSelectorManagedScriptProperties properties, MeterRegistry registry) {
        super(scriptManager, properties, registry);
    }

    @Override
    public ResourceSelectorScriptResult<Command> selectResource(Set<Command> resources, JobRequest jobRequest, String jobId) throws ResourceSelectionException {
        log.debug("Called to attempt to select a command from {} for job {}", resources, (Object)jobId);
        return super.selectResource(resources, jobRequest, jobId);
    }

    @Override
    protected void addParametersForScript(Map<String, Object> parameters, Set<Command> resources, JobRequest jobRequest) {
        super.addParametersForScript(parameters, resources, jobRequest);
        parameters.put(COMMANDS_BINDING, resources);
    }
}

