/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors.impl;

import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.web.dtos.ResourceSelectionResult;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.selectors.ResourceSelector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RandomResourceSelector<R>
implements ResourceSelector<R> {
    private static final Logger log = LoggerFactory.getLogger(RandomResourceSelector.class);
    static final String SELECTION_RATIONALE = "Selected randomly";
    private final Random random = new Random();

    RandomResourceSelector() {
    }

    @Override
    public ResourceSelectionResult<R> select(@NotEmpty Set<@Valid R> resources, @Valid JobRequest jobRequest, @NotBlank String jobId) throws ResourceSelectionException {
        log.debug("Called to select for job {}", (Object)jobId);
        ResourceSelectionResult.Builder builder = new ResourceSelectionResult.Builder(this.getClass());
        try {
            R selectedResource = this.randomlySelect(resources);
            return builder.withSelectionRationale(SELECTION_RATIONALE).withSelectedResource(selectedResource).build();
        }
        catch (Exception e) {
            throw new ResourceSelectionException(e);
        }
    }

    @Nullable
    private R randomlySelect(@NotEmpty Collection<R> resources) {
        int index = this.random.nextInt(resources.size());
        Iterator<R> resourceIterator = resources.iterator();
        R selectedResource = null;
        for (int i = 0; resourceIterator.hasNext() && i <= index; ++i) {
            selectedResource = resourceIterator.next();
        }
        return selectedResource;
    }
}

