/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.web.dtos.ResourceSelectionResult;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.scripts.ClusterSelectorManagedScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.selectors.ClusterSelector;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptClusterSelectorImpl
implements ClusterSelector {
    private static final Logger log = LoggerFactory.getLogger(ScriptClusterSelectorImpl.class);
    static final String SELECT_TIMER_NAME = "genie.jobs.clusters.selectors.script.select.timer";
    private static final String NULL_TAG = "null";
    private static final String NULL_RATIONALE = "Script returned null, no preference";
    private final MeterRegistry registry;
    private final ClusterSelectorManagedScript clusterSelectorManagedScript;

    public ScriptClusterSelectorImpl(ClusterSelectorManagedScript clusterSelectorManagedScript, MeterRegistry registry) {
        this.clusterSelectorManagedScript = clusterSelectorManagedScript;
        this.registry = registry;
    }

    @Override
    public ResourceSelectionResult<Cluster> select(@NotEmpty Set<@Valid Cluster> clusters, @Valid JobRequest jobRequest, @NotBlank String jobId) throws ResourceSelectionException {
        long selectStart = System.nanoTime();
        log.debug("Called to select cluster from {} for job {}", clusters, (Object)jobId);
        HashSet tags = Sets.newHashSet();
        ResourceSelectionResult.Builder builder = new ResourceSelectionResult.Builder(this.getClass());
        try {
            ResourceSelectorScriptResult<Cluster> result = this.clusterSelectorManagedScript.selectResource(clusters, jobRequest, jobId);
            MetricsUtils.addSuccessTags(tags);
            Optional<Cluster> clusterOptional = result.getResource();
            if (!clusterOptional.isPresent()) {
                String rationale = result.getRationale().orElse(NULL_RATIONALE);
                log.debug("No cluster selected due to: {}", (Object)rationale);
                tags.add(Tag.of((String)"clusterId", (String)NULL_TAG));
                builder.withSelectionRationale(rationale);
                ResourceSelectionResult<Cluster> resourceSelectionResult = builder.build();
                return resourceSelectionResult;
            }
            Cluster selectedCluster = clusterOptional.get();
            tags.add(Tag.of((String)"clusterId", (String)selectedCluster.getId()));
            tags.add(Tag.of((String)"clusterName", (String)selectedCluster.getMetadata().getName()));
            ResourceSelectionResult<Cluster> resourceSelectionResult = builder.withSelectionRationale(result.getRationale().orElse(null)).withSelectedResource(selectedCluster).build();
            return resourceSelectionResult;
        }
        catch (Throwable e) {
            String errorMessage = "Cluster selection error: " + e.getMessage();
            log.error(errorMessage, e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            if (e instanceof ResourceSelectionException) {
                throw e;
            }
            throw new ResourceSelectionException(e);
        }
        finally {
            this.registry.timer(SELECT_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - selectStart, TimeUnit.NANOSECONDS);
        }
    }
}

