/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.services.JobKillService;
import com.netflix.genie.web.services.JobKillServiceV4;
import com.netflix.genie.web.services.impl.JobKillServiceV3;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobKillServiceImpl
implements JobKillService {
    private static final Logger log = LoggerFactory.getLogger(JobKillServiceImpl.class);
    private final JobKillServiceV3 jobKillServiceV3;
    private final JobKillServiceV4 jobKillServiceV4;
    private final JobPersistenceService jobPersistenceService;

    public JobKillServiceImpl(JobKillServiceV3 jobKillServiceV3, JobKillServiceV4 jobKillServiceV4, DataServices dataServices) {
        this.jobKillServiceV3 = jobKillServiceV3;
        this.jobKillServiceV4 = jobKillServiceV4;
        this.jobPersistenceService = dataServices.getJobPersistenceService();
    }

    @Override
    public void killJob(@NotBlank(message="No id entered. Unable to kill job.") @NotBlank(message="No id entered. Unable to kill job.") String id, @NotBlank(message="No reason provided.") @NotBlank(message="No reason provided.") String reason) throws GenieException {
        if (this.jobPersistenceService.isV4(id)) {
            this.jobKillServiceV4.killJob(id, reason);
        } else {
            this.jobKillServiceV3.killJob(id, reason);
        }
    }
}

