/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.exceptions.checked.GenieJobResolutionException;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.dtos.JobSubmission;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.AgentLaunchException;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.SaveAttachmentException;
import com.netflix.genie.web.services.JobLaunchService;
import com.netflix.genie.web.services.JobResolverService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLaunchServiceImpl
implements JobLaunchService {
    private static final Logger log = LoggerFactory.getLogger(JobLaunchServiceImpl.class);
    private static final String LAUNCH_JOB_TIMER = "genie.services.jobLaunch.launchJob.timer";
    private final JobPersistenceService jobPersistenceService;
    private final JobResolverService jobResolverService;
    private final AgentLauncher agentLauncher;
    private final MeterRegistry registry;

    public JobLaunchServiceImpl(DataServices dataServices, JobResolverService jobResolverService, AgentLauncher agentLauncher, MeterRegistry registry) {
        this.jobPersistenceService = dataServices.getJobPersistenceService();
        this.jobResolverService = jobResolverService;
        this.agentLauncher = agentLauncher;
        this.registry = registry;
    }

    @Override
    @Nonnull
    public String launchJob(@Valid JobSubmission jobSubmission) throws AgentLaunchException, GenieJobResolutionException, IdAlreadyExistsException, SaveAttachmentException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            ResolvedJob resolvedJob;
            String jobId = this.jobPersistenceService.saveJobSubmission(jobSubmission);
            try {
                resolvedJob = this.jobResolverService.resolveJob(jobId);
            }
            catch (Throwable t) {
                MetricsUtils.addFailureTagsWithException(tags, t);
                this.jobPersistenceService.updateJobStatus(jobId, JobStatus.RESERVED, JobStatus.FAILED, t.getMessage());
                throw t;
            }
            try {
                this.jobPersistenceService.updateJobStatus(jobId, JobStatus.RESOLVED, JobStatus.ACCEPTED, "The job has been accepted by the system for execution");
            }
            catch (Throwable t) {
                throw new AgentLaunchException(t);
            }
            try {
                this.agentLauncher.launchAgent(resolvedJob);
            }
            catch (AgentLaunchException e) {
                this.jobPersistenceService.updateJobStatus(jobId, JobStatus.ACCEPTED, JobStatus.FAILED, e.getMessage());
                throw e;
            }
            MetricsUtils.addSuccessTags(tags);
            String string = jobId;
            return string;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.registry.timer(LAUNCH_JOB_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

