/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.JobEnvironment;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.exceptions.checked.GenieJobResolutionException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.web.data.services.ApplicationPersistenceService;
import com.netflix.genie.web.data.services.ClusterPersistenceService;
import com.netflix.genie.web.data.services.CommandPersistenceService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.dtos.ResourceSelectionResult;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.selectors.ClusterSelector;
import com.netflix.genie.web.selectors.CommandSelector;
import com.netflix.genie.web.services.JobResolverService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetClassAware;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class JobResolverServiceImpl
implements JobResolverService {
    private static final Logger log = LoggerFactory.getLogger(JobResolverServiceImpl.class);
    private static final String RESOLVE_JOB_TIMER = "genie.services.jobResolver.resolve.timer";
    private static final String CLUSTER_COMMAND_QUERY_TIMER = "genie.services.jobResolver.clusterCommandQuery.timer";
    private static final String RESOLVE_CLUSTER_TIMER = "genie.services.jobResolver.resolveCluster.timer";
    private static final String RESOLVE_CLUSTER_CRITERIA_COMBINATION_COUNTER = "genie.services.jobResolver.resolveCluster.criteriaCombination.count";
    private static final String RESOLVE_CLUSTER_QUERY_COUNTER = "genie.services.jobResolver.resolveCluster.query.count";
    private static final String RESOLVE_COMMAND_TIMER = "genie.services.jobResolver.resolveCommand.timer";
    private static final String SELECT_CLUSTER_TIMER = "genie.services.jobResolver.selectCluster.timer";
    private static final String SELECT_COMMAND_TIMER = "genie.services.jobResolver.selectCommand.timer";
    private static final String SELECT_APPLICATIONS_TIMER = "genie.services.jobResolver.selectApplications.timer";
    private static final String CLUSTER_SELECTOR_COUNTER = "genie.services.jobResolver.clusterSelector.counter";
    private static final String NO_RATIONALE = "No rationale provided";
    private static final String NO_ID_FOUND = "No id found";
    private static final String VERSION_4 = "4";
    private static final Tag SAVED_TAG = Tag.of((String)"saved", (String)"true");
    private static final Tag NOT_SAVED_TAG = Tag.of((String)"saved", (String)"false");
    private static final String ID_FIELD = "id";
    private static final String NAME_FIELD = "name";
    private static final String STATUS_FIELD = "status";
    private static final String VERSION_FIELD = "version";
    private static final String RESOLVE_CLUSTER_CRITERIA_COMBINATION_TAG = "criteriaCombinationCount";
    private static final String RESOLVE_CLUSTER_QUERY_TAG = "queryCount";
    private static final String CLUSTER_SELECTOR_STATUS_SUCCESS = "success";
    private static final String CLUSTER_SELECTOR_STATUS_NO_PREFERENCE = "no preference";
    private static final String CLUSTER_SELECTOR_STATUS_EXCEPTION = "exception";
    private static final String CLUSTER_SELECTOR_STATUS_INVALID = "invalid";
    private static final String V4_PROBABILITY_PROPERTY_KEY = "genie.services.job-resolver.v4-probability";
    private static final double DEFAULT_V4_PROBABILITY = 0.0;
    private static final double MIN_V4_PROBABILITY = 0.0;
    private static final double MAX_V4_PROBABILITY = 1.0;
    private static final String ALGORITHM_COUNTER = "genie.services.jobResolver.resolutionAlgorithm.counter";
    private static final String ALGORITHM_TAG = "algorithm";
    private static final Set<Tag> V3_ALGORITHM_TAGS = ImmutableSet.of((Object)Tag.of((String)"algorithm", (String)"v3"));
    private static final Set<Tag> V4_ALGORITHM_TAGS = ImmutableSet.of((Object)Tag.of((String)"algorithm", (String)"v4"));
    private static final String V3_COMMAND_TAG = "v3Command";
    private static final String V4_COMMAND_TAG = "v4Command";
    private static final String MATCHED_TAG = "matched";
    private static final Tag MATCHED_TAG_FALSE = Tag.of((String)"matched", (String)"false");
    private static final Tag MATCHED_TAG_TRUE = Tag.of((String)"matched", (String)"true");
    private static final String DUAL_RESOLVE_PROPERTY_KEY = "genie.services.job-resolver.dual-mode.enabled";
    private static final String DUAL_RESOLVE_TIMER = "genie.services.jobResolver.v4DualResolve.timer";
    private final ApplicationPersistenceService applicationPersistenceService;
    private final ClusterPersistenceService clusterPersistenceService;
    private final CommandPersistenceService commandPersistenceService;
    private final JobPersistenceService jobPersistenceService;
    private final List<ClusterSelector> clusterSelectors;
    private final CommandSelector commandSelector;
    private final MeterRegistry registry;
    private final int defaultMemory;
    private final File defaultJobDirectory;
    private final String defaultArchiveLocation;
    private final Counter noClusterSelectedCounter;
    private final Counter noClusterFoundCounter;
    private final Environment environment;
    private final Random random;

    public JobResolverServiceImpl(DataServices dataServices, @NotEmpty List<ClusterSelector> clusterSelectors, CommandSelector commandSelector, MeterRegistry registry, JobsProperties jobsProperties, Environment environment) {
        this.applicationPersistenceService = dataServices.getApplicationPersistenceService();
        this.clusterPersistenceService = dataServices.getClusterPersistenceService();
        this.commandPersistenceService = dataServices.getCommandPersistenceService();
        this.jobPersistenceService = dataServices.getJobPersistenceService();
        this.clusterSelectors = clusterSelectors;
        this.commandSelector = commandSelector;
        this.defaultMemory = jobsProperties.getMemory().getDefaultJobMemory();
        this.environment = environment;
        this.random = new Random();
        URI jobDirProperty = jobsProperties.getLocations().getJobs();
        this.defaultJobDirectory = Paths.get(jobDirProperty).toFile();
        this.defaultArchiveLocation = jobsProperties.getLocations().getArchives().toString();
        this.registry = registry;
        this.noClusterSelectedCounter = this.registry.counter("genie.services.jobResolver.selectCluster.noneSelected.counter", new String[0]);
        this.noClusterFoundCounter = this.registry.counter("genie.services.jobResolver.selectCluster.noneFound.counter", new String[0]);
    }

    @Override
    @Nonnull
    @Transactional
    public ResolvedJob resolveJob(String id) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet((Object[])new Tag[]{SAVED_TAG});
        try {
            log.info("Received request to resolve a job with id {}", (Object)id);
            JobStatus jobStatus = this.jobPersistenceService.getJobStatus(id);
            if (!jobStatus.isResolvable()) {
                throw new IllegalArgumentException("Job " + id + " is already resolved: " + jobStatus);
            }
            JobRequest jobRequest = this.jobPersistenceService.getJobRequest(id).orElseThrow(() -> new GenieJobNotFoundException("No job with id " + id + " exists."));
            boolean apiJob = this.jobPersistenceService.isApiJob(id);
            ResolvedJob resolvedJob = this.resolve(id, jobRequest, apiJob);
            this.jobPersistenceService.saveResolvedJob(id, resolvedJob);
            MetricsUtils.addSuccessTags(tags);
            ResolvedJob resolvedJob2 = resolvedJob;
            return resolvedJob2;
        }
        catch (GenieJobResolutionException e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(RESOLVE_JOB_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    @Nonnull
    public ResolvedJob resolveJob(String id, @Valid JobRequest jobRequest, boolean apiJob) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet((Object[])new Tag[]{NOT_SAVED_TAG});
        try {
            log.info("Received request to resolve a job for id {} and request {}", (Object)id, (Object)jobRequest);
            ResolvedJob resolvedJob = this.resolve(id, jobRequest, apiJob);
            MetricsUtils.addSuccessTags(tags);
            ResolvedJob resolvedJob2 = resolvedJob;
            return resolvedJob2;
        }
        catch (GenieJobResolutionException e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(RESOLVE_JOB_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolvedJob resolve(String id, JobRequest jobRequest, boolean apiJob) throws GenieJobResolutionException {
        Cluster cluster;
        Command command;
        if (this.useV4ResourceSelection()) {
            command = this.resolveCommand(jobRequest, id);
            cluster = this.resolveCluster(command, jobRequest, id);
        } else {
            Map<Cluster, String> clustersAndCommandsForJob = this.queryForClustersAndCommands(jobRequest.getCriteria().getClusterCriteria(), jobRequest.getCriteria().getCommandCriterion());
            cluster = this.selectCluster(id, jobRequest, clustersAndCommandsForJob.keySet());
            command = this.getCommand(clustersAndCommandsForJob.get(cluster), id);
            if (((Boolean)this.environment.getProperty(DUAL_RESOLVE_PROPERTY_KEY, Boolean.class, (Object)false)).booleanValue()) {
                long dualStart = System.nanoTime();
                String v3CommandId = command.getId();
                HashSet dualModeTags = Sets.newHashSet((Object[])new Tag[]{Tag.of((String)V3_COMMAND_TAG, (String)v3CommandId)});
                try {
                    Command v4Command = this.resolveCommand(jobRequest, id);
                    String v4CommandId = v4Command.getId();
                    dualModeTags.add(Tag.of((String)V4_COMMAND_TAG, (String)v4CommandId));
                    if (v4CommandId.equals(v3CommandId)) {
                        dualModeTags.add(MATCHED_TAG_TRUE);
                        log.info("V4 resource resolution match for job {} command {}", (Object)id, (Object)v3CommandId);
                    } else {
                        dualModeTags.add(MATCHED_TAG_FALSE);
                        log.info("V4 resource resolution mismatch for job {} V3 command {} V4 command {}", new Object[]{id, v3CommandId, v4CommandId});
                    }
                    MetricsUtils.addSuccessTags(dualModeTags);
                }
                catch (Exception e) {
                    MetricsUtils.addFailureTagsWithException(dualModeTags, e);
                    dualModeTags.add(MATCHED_TAG_FALSE);
                    log.info("V4 resource resolution mismatch for job {} due to exception {}", new Object[]{id, e.getMessage(), e});
                }
                finally {
                    this.registry.timer(DUAL_RESOLVE_TIMER, (Iterable)dualModeTags).record(System.nanoTime() - dualStart, TimeUnit.NANOSECONDS);
                }
            }
        }
        ArrayList applicationResources = Lists.newArrayList();
        for (Application application : this.getApplications(id, jobRequest, command)) {
            applicationResources.add(new JobSpecification.ExecutionResource(application.getId(), application.getResources()));
        }
        int jobMemory = this.resolveJobMemory(jobRequest, command);
        ImmutableMap<String, String> environmentVariables = this.generateEnvironmentVariables(id, jobRequest, cluster, command, jobMemory);
        Integer timeout = jobRequest.getRequestedAgentConfig().getTimeoutRequested().isPresent() ? (Integer)jobRequest.getRequestedAgentConfig().getTimeoutRequested().get() : (apiJob ? Integer.valueOf(604800) : null);
        JobSpecification jobSpecification = new JobSpecification(command.getExecutable(), jobRequest.getCommandArgs(), new JobSpecification.ExecutionResource(id, jobRequest.getResources()), new JobSpecification.ExecutionResource(cluster.getId(), cluster.getResources()), new JobSpecification.ExecutionResource(command.getId(), command.getResources()), (List)applicationResources, environmentVariables, jobRequest.getRequestedAgentConfig().isInteractive(), jobRequest.getRequestedAgentConfig().getRequestedJobDirectoryLocation().orElse(this.defaultJobDirectory), this.toArchiveLocation(jobRequest.getRequestedJobArchivalData().getRequestedArchiveLocationPrefix().orElse(this.defaultArchiveLocation), id), timeout);
        JobEnvironment jobEnvironment = new JobEnvironment.Builder(jobMemory).withEnvironmentVariables(environmentVariables).build();
        return new ResolvedJob(jobSpecification, jobEnvironment, jobRequest.getMetadata());
    }

    private Map<Cluster, String> queryForClustersAndCommands(List<Criterion> clusterCriteria, Criterion commandCriterion) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            Map<Cluster, String> clustersAndCommands = this.clusterPersistenceService.findClustersAndCommandsForCriteria(clusterCriteria, commandCriterion);
            MetricsUtils.addSuccessTags(tags);
            Map<Cluster, String> map = clustersAndCommands;
            return map;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(CLUSTER_COMMAND_QUERY_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Cluster selectCluster(String id, JobRequest jobRequest, Set<Cluster> clusters) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet timerTags = Sets.newHashSet();
        HashSet counterTags = Sets.newHashSet();
        try {
            if (clusters.isEmpty()) {
                this.noClusterFoundCounter.increment();
                throw new GeniePreconditionException("No cluster/command combination found for the given criteria. Unable to continue");
            }
            Cluster cluster = clusters.size() == 1 ? (Cluster)clusters.stream().findFirst().orElseThrow(() -> new GenieServerException("Couldn't get cluster when size was one")) : this.selectClusterUsingClusterSelectors(counterTags, clusters, jobRequest, id);
            if (cluster == null) {
                this.noClusterSelectedCounter.increment();
                throw new GenieJobResolutionException("No cluster found matching given criteria");
            }
            log.debug("Selected cluster {} for job {}", (Object)cluster.getId(), (Object)id);
            MetricsUtils.addSuccessTags(timerTags);
            Cluster cluster2 = cluster;
            return cluster2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(timerTags, t);
            if (t instanceof GenieJobResolutionException) {
                throw (GenieJobResolutionException)t;
            }
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(SELECT_CLUSTER_TIMER, (Iterable)timerTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Command getCommand(String commandId, String jobId) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            log.info("Selecting command for job {} ", (Object)jobId);
            Command command = this.commandPersistenceService.getCommand(commandId);
            log.info("Selected command {} for job {} ", (Object)commandId, (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
            Command command2 = command;
            return command2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(SELECT_COMMAND_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private List<Application> getApplications(String id, JobRequest jobRequest, Command command) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            String commandId = command.getId();
            log.info("Selecting applications for job {} and command {}", (Object)id, (Object)commandId);
            ArrayList applications = Lists.newArrayList();
            if (jobRequest.getCriteria().getApplicationIds().isEmpty()) {
                applications.addAll(this.commandPersistenceService.getApplicationsForCommand(commandId));
            } else {
                for (String applicationId : jobRequest.getCriteria().getApplicationIds()) {
                    applications.add(this.applicationPersistenceService.getApplication(applicationId));
                }
            }
            log.info("Selected applications {} for job {}", (Object)applications.stream().map(rec$ -> ((Application)rec$).getId()).reduce((one, two) -> one + "," + two).orElse(NO_ID_FOUND), (Object)id);
            MetricsUtils.addSuccessTags(tags);
            ArrayList arrayList = applications;
            return arrayList;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(SELECT_APPLICATIONS_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Cluster selectClusterUsingClusterSelectors(Set<Tag> counterTags, Set<Cluster> clusters, JobRequest jobRequest, String jobId) {
        Cluster cluster = null;
        for (ClusterSelector clusterSelector : this.clusterSelectors) {
            Class targetClass;
            String clusterSelectorClass = clusterSelector instanceof TargetClassAware ? ((targetClass = ((TargetClassAware)clusterSelector).getTargetClass()) != null ? targetClass.getCanonicalName() : clusterSelector.getClass().getCanonicalName()) : clusterSelector.getClass().getCanonicalName();
            counterTags.add(Tag.of((String)"class", (String)clusterSelectorClass));
            try {
                ResourceSelectionResult<Cluster> result = clusterSelector.select(clusters, jobRequest, jobId);
                Optional<Cluster> selectedClusterOptional = result.getSelectedResource();
                if (selectedClusterOptional.isPresent()) {
                    Cluster selectedCluster = selectedClusterOptional.get();
                    if (clusters.contains(selectedCluster)) {
                        log.debug("Successfully selected cluster {} using selector {}", (Object)selectedCluster.getId(), (Object)clusterSelectorClass);
                        counterTags.addAll(Lists.newArrayList((Object[])new Tag[]{Tag.of((String)STATUS_FIELD, (String)CLUSTER_SELECTOR_STATUS_SUCCESS), Tag.of((String)"clusterId", (String)selectedCluster.getId()), Tag.of((String)"clusterName", (String)selectedCluster.getMetadata().getName()), Tag.of((String)"clusterSelectorClass", (String)clusterSelectorClass)}));
                        cluster = selectedCluster;
                        break;
                    }
                    log.error("Successfully selected cluster {} using selector {} but it wasn't in original cluster list {}", new Object[]{selectedCluster.getId(), clusterSelectorClass, clusters});
                    counterTags.add(Tag.of((String)STATUS_FIELD, (String)CLUSTER_SELECTOR_STATUS_INVALID));
                    continue;
                }
                counterTags.add(Tag.of((String)STATUS_FIELD, (String)CLUSTER_SELECTOR_STATUS_NO_PREFERENCE));
            }
            catch (Exception e) {
                log.error("Cluster selector {} evaluation threw exception:", (Object)clusterSelector, (Object)e);
                counterTags.add(Tag.of((String)STATUS_FIELD, (String)CLUSTER_SELECTOR_STATUS_EXCEPTION));
            }
            finally {
                this.registry.counter(CLUSTER_SELECTOR_COUNTER, counterTags).increment();
            }
        }
        return cluster;
    }

    private ImmutableMap<String, String> generateEnvironmentVariables(String id, JobRequest jobRequest, Cluster cluster, Command command, int memory) {
        ImmutableMap.Builder envVariables = ImmutableMap.builder();
        envVariables.put((Object)"GENIE_VERSION", (Object)VERSION_4);
        envVariables.put((Object)"GENIE_CLUSTER_ID", (Object)cluster.getId());
        envVariables.put((Object)"GENIE_CLUSTER_NAME", (Object)cluster.getMetadata().getName());
        envVariables.put((Object)"GENIE_CLUSTER_TAGS", (Object)this.tagsToString(cluster.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_COMMAND_ID", (Object)command.getId());
        envVariables.put((Object)"GENIE_COMMAND_NAME", (Object)command.getMetadata().getName());
        envVariables.put((Object)"GENIE_COMMAND_TAGS", (Object)this.tagsToString(command.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_JOB_ID", (Object)id);
        envVariables.put((Object)"GENIE_JOB_NAME", (Object)jobRequest.getMetadata().getName());
        envVariables.put((Object)"GENIE_JOB_MEMORY", (Object)String.valueOf(memory));
        envVariables.put((Object)"GENIE_JOB_TAGS", (Object)this.tagsToString(jobRequest.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_JOB_GROUPING", (Object)jobRequest.getMetadata().getGrouping().orElse(""));
        envVariables.put((Object)"GENIE_JOB_GROUPING_INSTANCE", (Object)jobRequest.getMetadata().getGroupingInstance().orElse(""));
        envVariables.put((Object)"GENIE_REQUESTED_COMMAND_TAGS", (Object)this.tagsToString(jobRequest.getCriteria().getCommandCriterion().getTags()));
        List clusterCriteria = jobRequest.getCriteria().getClusterCriteria();
        ArrayList clusterCriteriaTags = Lists.newArrayListWithExpectedSize((int)clusterCriteria.size());
        for (int i = 0; i < clusterCriteria.size(); ++i) {
            Criterion criterion = (Criterion)clusterCriteria.get(i);
            String criteriaTagsString = this.tagsToString(criterion.getTags());
            envVariables.put((Object)("GENIE_REQUESTED_CLUSTER_TAGS_" + i), (Object)criteriaTagsString);
            clusterCriteriaTags.add("[" + criteriaTagsString + "]");
        }
        envVariables.put((Object)"GENIE_REQUESTED_CLUSTER_TAGS", (Object)("[" + StringUtils.join((Iterable)clusterCriteriaTags, (char)',') + "]"));
        envVariables.put((Object)"GENIE_USER", (Object)jobRequest.getMetadata().getUser());
        envVariables.put((Object)"GENIE_USER_GROUP", (Object)jobRequest.getMetadata().getGroup().orElse(""));
        return envVariables.build();
    }

    private String tagsToString(Set<String> tags) {
        ArrayList sortedTags = Lists.newArrayList(tags);
        sortedTags.sort(Comparator.naturalOrder());
        String joinedString = StringUtils.join((Iterable)sortedTags, (char)',');
        return RegExUtils.replaceAll((String)RegExUtils.replaceAll((String)joinedString, (String)"'", (String)"\\'"), (String)"\"", (String)"\\\"");
    }

    private String toArchiveLocation(String requestedArchiveLocationPrefix, String jobId) {
        String archivePrefix;
        String string = archivePrefix = StringUtils.isBlank((CharSequence)requestedArchiveLocationPrefix) ? this.defaultArchiveLocation : requestedArchiveLocationPrefix;
        if (archivePrefix.endsWith(File.separator)) {
            return archivePrefix + jobId;
        }
        return archivePrefix + File.separator + jobId;
    }

    private int resolveJobMemory(JobRequest jobRequest, Command command) {
        return jobRequest.getRequestedJobEnvironment().getRequestedJobMemory().orElse(command.getMemory().orElse(this.defaultMemory));
    }

    private boolean useV4ResourceSelection() {
        double v4Probability;
        try {
            v4Probability = (Double)this.environment.getProperty(V4_PROBABILITY_PROPERTY_KEY, Double.class, (Object)0.0);
        }
        catch (IllegalStateException e) {
            log.error("Invalid V4 probability. Expected a number between 0.0 and 1.0 inclusive.", (Throwable)e);
            v4Probability = 0.0;
        }
        if (v4Probability < 0.0) {
            log.warn("Invalid V4 resolution probability {}. Must be >= 0.0. Resetting to {}", (Object)v4Probability, (Object)0.0);
            v4Probability = 0.0;
        }
        if (v4Probability > 1.0) {
            log.warn("Invalid V4 resolution probability {}. Must be <= 1.0. Resetting to {}", (Object)v4Probability, (Object)1.0);
            v4Probability = 1.0;
        }
        if (this.random.nextDouble() < v4Probability) {
            this.registry.counter(ALGORITHM_COUNTER, V4_ALGORITHM_TAGS).increment();
            return true;
        }
        this.registry.counter(ALGORITHM_COUNTER, V3_ALGORITHM_TAGS).increment();
        return false;
    }

    private Command resolveCommand(JobRequest jobRequest, String jobId) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            Command command;
            Criterion criterion = jobRequest.getCriteria().getCommandCriterion();
            Set<Command> commands = this.commandPersistenceService.findCommandsMatchingCriterion(criterion, true);
            if (commands.isEmpty()) {
                throw new GenieJobResolutionException("No command matching command criterion found");
            }
            if (commands.size() == 1) {
                command = (Command)commands.stream().findFirst().orElseThrow(() -> new GenieJobResolutionException("No command matching criterion found."));
                log.debug("Found single command {} matching criterion {}", (Object)command.getId(), (Object)criterion);
            } else {
                try {
                    ResourceSelectionResult<Command> result = this.commandSelector.select(commands, jobRequest, jobId);
                    command = result.getSelectedResource().orElseThrow(() -> new GenieJobResolutionException("Expected a command but " + result.getSelectorClass().getSimpleName() + " didn't select anything. Rationale: " + result.getSelectionRationale().orElse(NO_RATIONALE)));
                    log.debug("Selected command {} for criterion {} using {} due to {}", new Object[]{command.getId(), criterion, result.getSelectorClass().getName(), result.getSelectionRationale().orElse(NO_RATIONALE)});
                }
                catch (ResourceSelectionException selectionException) {
                    throw new GenieJobResolutionException((Throwable)((Object)selectionException));
                }
            }
            MetricsUtils.addSuccessTags(tags);
            tags.add(Tag.of((String)"commandId", (String)command.getId()));
            tags.add(Tag.of((String)"commandName", (String)command.getMetadata().getName()));
            Command command2 = command;
            return command2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            if (t instanceof GenieJobResolutionException) {
                throw t;
            }
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(RESOLVE_COMMAND_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Cluster resolveCluster(Command command, JobRequest jobRequest, String jobId) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        int queryCount = 0;
        int criteriaCombinationCount = 0;
        try {
            Cluster cluster = null;
            for (Criterion commandClusterCriterion : command.getClusterCriteria()) {
                for (Criterion jobClusterCriterion : jobRequest.getCriteria().getClusterCriteria()) {
                    Criterion mergedCriterion;
                    ++criteriaCombinationCount;
                    try {
                        mergedCriterion = this.mergeCriteria(commandClusterCriterion, jobClusterCriterion);
                    }
                    catch (IllegalArgumentException e) {
                        log.debug("Unable to merge command cluster criterion {} and job cluster criterion {}. Skipping.", new Object[]{commandClusterCriterion, jobClusterCriterion, e});
                        continue;
                    }
                    ++queryCount;
                    Set<Cluster> clusters = this.clusterPersistenceService.findClustersMatchingCriterion(mergedCriterion, true);
                    if (clusters.isEmpty()) {
                        log.debug("No clusters found for {}", (Object)mergedCriterion);
                        this.noClusterFoundCounter.increment();
                    } else if (clusters.size() == 1) {
                        log.debug("Found single cluster for {}", (Object)mergedCriterion);
                        cluster = clusters.stream().findFirst().orElse(null);
                    } else {
                        log.debug("Found {} clusters for {}", (Object)clusters.size(), (Object)mergedCriterion);
                        cluster = this.selectClusterUsingClusterSelectors(Sets.newHashSet(), clusters, jobRequest, jobId);
                    }
                    if (cluster == null) continue;
                    break;
                }
                if (cluster == null) continue;
                break;
            }
            if (cluster == null) {
                this.noClusterSelectedCounter.increment();
                throw new GenieJobResolutionException("No cluster selected given criteria for job " + jobId);
            }
            log.debug("Selected cluster {} for job {}", (Object)cluster.getId(), (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
            tags.add(Tag.of((String)"clusterId", (String)cluster.getId()));
            tags.add(Tag.of((String)"clusterName", (String)cluster.getMetadata().getName()));
            Iterator iterator = cluster;
            return iterator;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            if (t instanceof GenieJobResolutionException) {
                throw (GenieJobResolutionException)t;
            }
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.counter(RESOLVE_CLUSTER_CRITERIA_COMBINATION_COUNTER, new String[0]).increment((double)criteriaCombinationCount);
            this.registry.counter(RESOLVE_CLUSTER_QUERY_COUNTER, new String[0]).increment((double)queryCount);
            tags.add(Tag.of((String)RESOLVE_CLUSTER_CRITERIA_COMBINATION_TAG, (String)String.valueOf(criteriaCombinationCount)));
            tags.add(Tag.of((String)RESOLVE_CLUSTER_QUERY_TAG, (String)String.valueOf(queryCount)));
            this.registry.timer(RESOLVE_CLUSTER_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Criterion mergeCriteria(Criterion one, Criterion two) throws IllegalArgumentException {
        Criterion.Builder builder = new Criterion.Builder();
        builder.withId(this.mergeCriteriaStrings(one.getId().orElse(null), two.getId().orElse(null), ID_FIELD));
        builder.withName(this.mergeCriteriaStrings(one.getName().orElse(null), two.getName().orElse(null), NAME_FIELD));
        builder.withStatus(this.mergeCriteriaStrings(one.getStatus().orElse(null), two.getStatus().orElse(null), STATUS_FIELD));
        builder.withVersion(this.mergeCriteriaStrings(one.getVersion().orElse(null), two.getVersion().orElse(null), VERSION_FIELD));
        HashSet tags = Sets.newHashSet((Iterable)one.getTags());
        tags.addAll(two.getTags());
        builder.withTags((Set)tags);
        return builder.build();
    }

    private String mergeCriteriaStrings(@Nullable String one, @Nullable String two, String fieldName) throws IllegalArgumentException {
        if (StringUtils.equals((CharSequence)one, (CharSequence)two)) {
            return one;
        }
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        throw new IllegalArgumentException(fieldName + "'s were both present but not equal");
    }
}

