/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.amazonaws.util.StringUtils;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.services.FileTransfer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileTransferImpl
implements FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(LocalFileTransferImpl.class);
    private static final String FILE_SCHEME = "file:";
    private static final String ENTIRE_FILE_SCHEME = "file://";

    @Override
    public boolean isValid(@NotBlank(message="Filename cannot be blank") @NotBlank(message="Filename cannot be blank") String fileName) throws GenieException {
        log.debug("Called with file name {}", (Object)fileName);
        return true;
    }

    @Override
    public void getFile(@NotBlank(message="Source file path cannot be empty.") @NotBlank(message="Source file path cannot be empty.") String srcRemotePath, @NotBlank(message="Destination local path cannot be empty") @NotBlank(message="Destination local path cannot be empty") String dstLocalPath) throws GenieException {
        log.debug("Called to get {} and put it to {}", (Object)srcRemotePath, (Object)dstLocalPath);
        this.copy(srcRemotePath, dstLocalPath);
    }

    @Override
    public void putFile(@NotBlank(message="Source local path cannot be empty.") @NotBlank(message="Source local path cannot be empty.") String srcLocalPath, @NotBlank(message="Destination remote path cannot be empty") @NotBlank(message="Destination remote path cannot be empty") String dstRemotePath) throws GenieException {
        log.debug("Called to take {} and put it to {}", (Object)srcLocalPath, (Object)dstRemotePath);
        this.copy(srcLocalPath, dstRemotePath);
    }

    @Override
    public long getLastModifiedTime(String path) throws GenieException {
        try {
            return Files.getLastModifiedTime(this.createFilePath(path), new LinkOption[0]).toMillis();
        }
        catch (Exception e) {
            String message = String.format("Failed getting the last modified time for file with path %s", path);
            log.error(message, (Throwable)e);
            throw new GenieServerException(message, (Throwable)e);
        }
    }

    private void copy(String srcPath, String dstPath) throws GenieServerException {
        try {
            Path src = this.createFilePath(srcPath);
            Path dest = this.createFilePath(dstPath);
            Path parent = dest.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            log.error("Got error while copying file {} to {}", new Object[]{srcPath, dstPath, ioe});
            throw new GenieServerException("Got error while copying file " + srcPath + " to " + dstPath, (Throwable)ioe);
        }
    }

    private Path createFilePath(String path) throws GenieServerException {
        log.debug("Normalizing path from {}", (Object)path);
        String finalPath = StringUtils.beginsWithIgnoreCase((String)path, (String)ENTIRE_FILE_SCHEME) ? path : (StringUtils.beginsWithIgnoreCase((String)path, (String)FILE_SCHEME) ? path.replace(FILE_SCHEME, ENTIRE_FILE_SCHEME) : ENTIRE_FILE_SCHEME + path);
        log.debug("Final path of {} after normalization is {}", (Object)path, (Object)finalPath);
        try {
            return Paths.get(new URI(finalPath));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            log.error("Unable to convert {} to java.nio.file.Path due to {}", new Object[]{finalPath, e.getMessage(), e});
            throw new GenieServerException("Failed to get file path", (Throwable)e);
        }
    }
}

