/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.google.common.collect.Sets;
import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.jobs.JobConstants;
import com.netflix.genie.web.data.services.ApplicationPersistenceService;
import com.netflix.genie.web.data.services.ClusterPersistenceService;
import com.netflix.genie.web.data.services.CommandPersistenceService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.FilePersistenceService;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.data.services.TagPersistenceService;
import com.netflix.genie.web.properties.DatabaseCleanupProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.TaskUtils;
import com.netflix.genie.web.tasks.leader.LeaderTask;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class DatabaseCleanupTask
extends LeaderTask {
    private static final Logger log = LoggerFactory.getLogger(DatabaseCleanupTask.class);
    private static final String DATABASE_CLEANUP_DURATION_TIMER_NAME = "genie.tasks.databaseCleanup.duration.timer";
    private static final String APPLICATION_DELETION_TIMER = "genie.tasks.databaseCleanup.applicationDeletion.timer";
    private static final String CLUSTER_DELETION_TIMER = "genie.tasks.databaseCleanup.clusterDeletion.timer";
    private static final String COMMAND_DEACTIVATION_TIMER = "genie.tasks.databaseCleanup.commandDeactivation.timer";
    private static final String COMMAND_DELETION_TIMER = "genie.tasks.databaseCleanup.commandDeletion.timer";
    private static final String FILE_DELETION_TIMER = "genie.tasks.databaseCleanup.fileDeletion.timer";
    private static final String TAG_DELETION_TIMER = "genie.tasks.databaseCleanup.tagDeletion.timer";
    private static final Set<CommandStatus> TO_DEACTIVATE_COMMAND_STATUSES = EnumSet.of(CommandStatus.DEPRECATED, CommandStatus.ACTIVE);
    private static final Set<CommandStatus> TO_DELETE_COMMAND_STATUSES = EnumSet.of(CommandStatus.INACTIVE);
    private static final Set<ClusterStatus> TO_DELETE_CLUSTER_STATUSES = EnumSet.of(ClusterStatus.TERMINATED);
    private final DatabaseCleanupProperties cleanupProperties;
    private final Environment environment;
    private final JobPersistenceService jobPersistenceService;
    private final ClusterPersistenceService clusterPersistenceService;
    private final CommandPersistenceService commandPersistenceService;
    private final ApplicationPersistenceService applicationPersistenceService;
    private final FilePersistenceService filePersistenceService;
    private final TagPersistenceService tagPersistenceService;
    private final MeterRegistry registry;
    private final AtomicLong numDeletedJobs;
    private final AtomicLong numDeletedClusters;
    private final AtomicLong numDeactivatedCommands;
    private final AtomicLong numDeletedCommands;
    private final AtomicLong numDeletedApplications;
    private final AtomicLong numDeletedTags;
    private final AtomicLong numDeletedFiles;

    public DatabaseCleanupTask(@NotNull DatabaseCleanupProperties cleanupProperties, @NotNull Environment environment, @NotNull DataServices dataServices, @NotNull MeterRegistry registry) {
        this.registry = registry;
        this.cleanupProperties = cleanupProperties;
        this.environment = environment;
        this.jobPersistenceService = dataServices.getJobPersistenceService();
        this.clusterPersistenceService = dataServices.getClusterPersistenceService();
        this.commandPersistenceService = dataServices.getCommandPersistenceService();
        this.applicationPersistenceService = dataServices.getApplicationPersistenceService();
        this.filePersistenceService = dataServices.getFilePersistenceService();
        this.tagPersistenceService = dataServices.getTagPersistenceService();
        this.numDeletedJobs = (AtomicLong)this.registry.gauge("genie.tasks.databaseCleanup.numDeletedJobs.gauge", (Number)new AtomicLong());
        this.numDeletedClusters = (AtomicLong)this.registry.gauge("genie.tasks.databaseCleanup.numDeletedClusters.gauge", (Number)new AtomicLong());
        this.numDeactivatedCommands = (AtomicLong)this.registry.gauge("genie.tasks.databaseCleanup.numDeactivatedCommands.gauge", (Number)new AtomicLong());
        this.numDeletedCommands = (AtomicLong)this.registry.gauge("genie.tasks.databaseCleanup.numDeletedCommands.gauge", (Number)new AtomicLong());
        this.numDeletedApplications = (AtomicLong)this.registry.gauge("genie.tasks.databaseCleanup.numDeletedApplications.gauge", (Number)new AtomicLong());
        this.numDeletedTags = (AtomicLong)this.registry.gauge("genie.tasks.databaseCleanup.numDeletedTags.gauge", (Number)new AtomicLong());
        this.numDeletedFiles = (AtomicLong)this.registry.gauge("genie.tasks.databaseCleanup.numDeletedFiles.gauge", (Number)new AtomicLong());
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.TRIGGER;
    }

    @Override
    public Trigger getTrigger() {
        String expression = (String)this.environment.getProperty("genie.tasks.database-cleanup.expression", String.class, (Object)this.cleanupProperties.getExpression());
        return new CronTrigger(expression, JobConstants.UTC);
    }

    @Override
    public void run() {
        long start = System.nanoTime();
        Instant runtime = Instant.now();
        HashSet tags = Sets.newHashSet();
        try {
            this.deleteJobs();
            Instant creationThreshold = runtime.minus(1L, ChronoUnit.HOURS);
            this.deleteClusters(creationThreshold);
            this.deactivateCommands(runtime);
            this.deleteCommands(creationThreshold);
            this.deleteApplications(creationThreshold);
            this.deleteFiles(creationThreshold);
            this.deleteTags(creationThreshold);
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.registry.timer(DATABASE_CLEANUP_DURATION_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void cleanup() {
        this.numDeletedJobs.set(0L);
        this.numDeletedClusters.set(0L);
        this.numDeactivatedCommands.set(0L);
        this.numDeletedCommands.set(0L);
        this.numDeletedApplications.set(0L);
        this.numDeletedTags.set(0L);
        this.numDeletedFiles.set(0L);
    }

    private void deleteJobs() {
        boolean skipJobs = (Boolean)this.environment.getProperty("genie.tasks.database-cleanup.job-cleanup.skip", Boolean.class, (Object)this.cleanupProperties.getJobCleanup().isSkip());
        if (skipJobs) {
            log.info("Skipping job cleanup");
            this.numDeletedJobs.set(0L);
        } else {
            long numDeletedJobsInBatch;
            Instant midnightUTC = TaskUtils.getMidnightUTC();
            Instant retentionLimit = midnightUTC.minus(((Integer)this.environment.getProperty("genie.tasks.database-cleanup.job-cleanup.retention", Integer.class, (Object)this.cleanupProperties.getJobCleanup().getRetention())).intValue(), ChronoUnit.DAYS);
            int batchSize = (Integer)this.environment.getProperty("genie.tasks.database-cleanup.job-cleanup.pageSize", Integer.class, (Object)this.cleanupProperties.getJobCleanup().getPageSize());
            log.info("Attempting to delete jobs from before {} in batches of {} jobs per iteration", (Object)retentionLimit, (Object)batchSize);
            long totalDeletedJobs = 0L;
            do {
                numDeletedJobsInBatch = this.jobPersistenceService.deleteJobsCreatedBefore(retentionLimit, JobStatus.getActiveStatuses(), batchSize);
                totalDeletedJobs += numDeletedJobsInBatch;
            } while (numDeletedJobsInBatch != 0L);
            log.info("Deleted {} jobs", (Object)totalDeletedJobs);
            this.numDeletedJobs.set(totalDeletedJobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteClusters(Instant creationThreshold) {
        long startTime = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            boolean skipClusters = (Boolean)this.environment.getProperty("genie.tasks.database-cleanup.cluster-cleanup.skip", Boolean.class, (Object)this.cleanupProperties.getClusterCleanup().isSkip());
            if (skipClusters) {
                log.info("Skipping clusters cleanup");
                this.numDeletedClusters.set(0L);
            } else {
                long countDeletedClusters = this.clusterPersistenceService.deleteUnusedClusters(TO_DELETE_CLUSTER_STATUSES, creationThreshold);
                log.info("Deleted {} clusters that were in one of {} states, were created before {} and weren't  attached to any jobs", new Object[]{countDeletedClusters, TO_DELETE_CLUSTER_STATUSES, creationThreshold});
                this.numDeletedClusters.set(countDeletedClusters);
            }
        }
        catch (Exception e) {
            log.error("Unable to delete clusters from database", (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
        }
        finally {
            this.registry.timer(CLUSTER_DELETION_TIMER, (Iterable)tags).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFiles(Instant creationThreshold) {
        long startTime = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            boolean skipFiles = (Boolean)this.environment.getProperty("genie.tasks.database-cleanup.file-cleanup.skip", Boolean.class, (Object)this.cleanupProperties.getFileCleanup().isSkip());
            if (skipFiles) {
                log.info("Skipping files cleanup");
                this.numDeletedFiles.set(0L);
            } else {
                long countDeletedFiles = this.filePersistenceService.deleteUnusedFiles(creationThreshold);
                log.info("Deleted {} files that were unused by any resource and created over an hour ago", (Object)countDeletedFiles);
                this.numDeletedFiles.set(countDeletedFiles);
            }
        }
        catch (Exception e) {
            log.error("Unable to delete files from database", (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
        }
        finally {
            this.registry.timer(FILE_DELETION_TIMER, (Iterable)tags).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTags(Instant creationThreshold) {
        long startTime = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            boolean skipTags = (Boolean)this.environment.getProperty("genie.tasks.database-cleanup.tag-cleanup.skip", Boolean.class, (Object)this.cleanupProperties.getTagCleanup().isSkip());
            if (skipTags) {
                log.info("Skipping tags cleanup");
                this.numDeletedTags.set(0L);
            } else {
                long countDeletedTags = this.tagPersistenceService.deleteUnusedTags(creationThreshold);
                log.info("Deleted {} tags that were unused by any resource and created over an hour ago", (Object)countDeletedTags);
                this.numDeletedTags.set(countDeletedTags);
            }
        }
        catch (Exception e) {
            log.error("Unable to delete tags from database", (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
        }
        finally {
            this.registry.timer(TAG_DELETION_TIMER, (Iterable)tags).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateCommands(Instant runtime) {
        long startTime = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            boolean skipDeactivation = (Boolean)this.environment.getProperty("genie.tasks.database-cleanup.command-deactivation.skip", Boolean.class, (Object)this.cleanupProperties.getCommandDeactivation().isSkip());
            if (skipDeactivation) {
                log.info("Skipping command deactivation");
                this.numDeactivatedCommands.set(0L);
            } else {
                Instant commandCreationThreshold = runtime.minus(((Integer)this.environment.getProperty("genie.tasks.database-cleanup.command-deactivation.commandCreationThreshold", Integer.class, (Object)this.cleanupProperties.getCommandDeactivation().getCommandCreationThreshold())).intValue(), ChronoUnit.DAYS);
                Instant jobCreationThreshold = runtime.minus(((Integer)this.environment.getProperty("genie.tasks.database-cleanup.command-deactivation.jobCreationThreshold", Integer.class, (Object)this.cleanupProperties.getCommandDeactivation().getJobCreationThreshold())).intValue(), ChronoUnit.DAYS);
                int deactivatedCommandCount = this.commandPersistenceService.updateStatusForUnusedCommands(CommandStatus.INACTIVE, commandCreationThreshold, TO_DEACTIVATE_COMMAND_STATUSES, jobCreationThreshold);
                log.info("Set {} commands to status {} that were previously in one of {}", new Object[]{deactivatedCommandCount, CommandStatus.INACTIVE, TO_DEACTIVATE_COMMAND_STATUSES});
                this.numDeactivatedCommands.set(deactivatedCommandCount);
            }
        }
        catch (Exception e) {
            log.error("Unable to disable commands in database", (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
        }
        finally {
            this.registry.timer(COMMAND_DEACTIVATION_TIMER, (Iterable)tags).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCommands(Instant creationThreshold) {
        long startTime = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            boolean skipCommands = (Boolean)this.environment.getProperty("genie.tasks.database-cleanup.command-cleanup.skip", Boolean.class, (Object)this.cleanupProperties.getCommandCleanup().isSkip());
            if (skipCommands) {
                log.info("Skipping command cleanup");
                this.numDeletedCommands.set(0L);
            } else {
                long deletedCommandCount = this.commandPersistenceService.deleteUnusedCommands(TO_DELETE_COMMAND_STATUSES, creationThreshold);
                log.info("Deleted {} commands that were unused by any resource and created over an hour ago", (Object)deletedCommandCount);
                this.numDeletedCommands.set(deletedCommandCount);
            }
        }
        catch (Exception e) {
            log.error("Unable to delete commands in database", (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
        }
        finally {
            this.registry.timer(COMMAND_DELETION_TIMER, (Iterable)tags).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteApplications(Instant creationThreshold) {
        long startTime = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            boolean skipApplications = (Boolean)this.environment.getProperty("genie.tasks.database-cleanup.application-cleanup.skip", Boolean.class, (Object)this.cleanupProperties.getApplicationCleanup().isSkip());
            if (skipApplications) {
                log.info("Skipping application cleanup");
                this.numDeletedCommands.set(0L);
            } else {
                long deletedApplicationCount = this.applicationPersistenceService.deleteUnusedApplicationsCreatedBefore(creationThreshold);
                log.info("Deleted {} applications that were unused by any resource and created over an hour ago", (Object)deletedApplicationCount);
                this.numDeletedApplications.set(deletedApplicationCount);
            }
        }
        catch (Exception e) {
            log.error("Unable to delete applications in database", (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
        }
        finally {
            this.registry.timer(APPLICATION_DELETION_TIMER, (Iterable)tags).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }
}

