/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.v4.endpoints;

import com.netflix.genie.common.external.dtos.v4.AgentClientMetadata;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.dtos.v4.converters.JobServiceProtoConverter;
import com.netflix.genie.proto.ChangeJobStatusRequest;
import com.netflix.genie.proto.ChangeJobStatusResponse;
import com.netflix.genie.proto.ClaimJobRequest;
import com.netflix.genie.proto.ClaimJobResponse;
import com.netflix.genie.proto.ConfigureRequest;
import com.netflix.genie.proto.ConfigureResponse;
import com.netflix.genie.proto.DryRunJobSpecificationRequest;
import com.netflix.genie.proto.HandshakeRequest;
import com.netflix.genie.proto.HandshakeResponse;
import com.netflix.genie.proto.JobServiceGrpc;
import com.netflix.genie.proto.JobSpecificationRequest;
import com.netflix.genie.proto.JobSpecificationResponse;
import com.netflix.genie.proto.ReserveJobIdRequest;
import com.netflix.genie.proto.ReserveJobIdResponse;
import com.netflix.genie.web.agent.apis.rpc.v4.endpoints.JobServiceProtoErrorComposer;
import com.netflix.genie.web.agent.services.AgentJobService;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcJobServiceImpl
extends JobServiceGrpc.JobServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(GRpcJobServiceImpl.class);
    private final AgentJobService agentJobService;
    private final JobServiceProtoConverter jobServiceProtoConverter;
    private final JobServiceProtoErrorComposer protoErrorComposer;

    public GRpcJobServiceImpl(AgentJobService agentJobService, JobServiceProtoConverter jobServiceProtoConverter, JobServiceProtoErrorComposer protoErrorComposer) {
        this.agentJobService = agentJobService;
        this.jobServiceProtoConverter = jobServiceProtoConverter;
        this.protoErrorComposer = protoErrorComposer;
    }

    public void handshake(HandshakeRequest request, StreamObserver<HandshakeResponse> responseObserver) {
        try {
            AgentClientMetadata agentMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            this.agentJobService.handshake(agentMetadata);
            responseObserver.onNext((Object)HandshakeResponse.newBuilder().setMessage("Agent is allowed to proceed").setType(HandshakeResponse.Type.ALLOWED).build());
        }
        catch (Exception e) {
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoHandshakeResponse(e));
        }
        responseObserver.onCompleted();
    }

    public void configure(ConfigureRequest request, StreamObserver<ConfigureResponse> responseObserver) {
        try {
            AgentClientMetadata agentMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            Map<String, String> agentProperties = this.agentJobService.getAgentProperties(agentMetadata);
            responseObserver.onNext((Object)ConfigureResponse.newBuilder().putAllProperties(agentProperties).build());
        }
        catch (Exception e) {
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoConfigureResponse(e));
        }
        responseObserver.onCompleted();
    }

    public void reserveJobId(ReserveJobIdRequest request, StreamObserver<ReserveJobIdResponse> responseObserver) {
        try {
            JobRequest jobRequest = this.jobServiceProtoConverter.toJobRequestDto(request);
            AgentClientMetadata agentClientMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            String jobId = this.agentJobService.reserveJobId(jobRequest, agentClientMetadata);
            responseObserver.onNext((Object)ReserveJobIdResponse.newBuilder().setId(jobId).build());
        }
        catch (Exception e) {
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoReserveJobIdResponse(e));
        }
        responseObserver.onCompleted();
    }

    public void resolveJobSpecification(JobSpecificationRequest request, StreamObserver<JobSpecificationResponse> responseObserver) {
        try {
            String id = request.getId();
            JobSpecification jobSpec = this.agentJobService.resolveJobSpecification(id);
            responseObserver.onNext((Object)this.jobServiceProtoConverter.toJobSpecificationResponseProto(jobSpec));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoJobSpecificationResponse(e));
        }
        responseObserver.onCompleted();
    }

    public void getJobSpecification(JobSpecificationRequest request, StreamObserver<JobSpecificationResponse> responseObserver) {
        try {
            String id = request.getId();
            JobSpecification jobSpecification = this.agentJobService.getJobSpecification(id);
            responseObserver.onNext((Object)this.jobServiceProtoConverter.toJobSpecificationResponseProto(jobSpecification));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoJobSpecificationResponse(e));
        }
        responseObserver.onCompleted();
    }

    public void resolveJobSpecificationDryRun(DryRunJobSpecificationRequest request, StreamObserver<JobSpecificationResponse> responseObserver) {
        try {
            JobRequest jobRequest = this.jobServiceProtoConverter.toJobRequestDto(request);
            JobSpecification jobSpecification = this.agentJobService.dryRunJobSpecificationResolution(jobRequest);
            responseObserver.onNext((Object)this.jobServiceProtoConverter.toJobSpecificationResponseProto(jobSpecification));
        }
        catch (Exception e) {
            log.error("Error resolving job specification for request " + request, (Throwable)e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoJobSpecificationResponse(e));
        }
        responseObserver.onCompleted();
    }

    public void claimJob(ClaimJobRequest request, StreamObserver<ClaimJobResponse> responseObserver) {
        try {
            String id = request.getId();
            AgentClientMetadata clientMetadata = this.jobServiceProtoConverter.toAgentClientMetadataDto(request.getAgentMetadata());
            this.agentJobService.claimJob(id, clientMetadata);
            responseObserver.onNext((Object)ClaimJobResponse.newBuilder().setSuccessful(true).build());
        }
        catch (Exception e) {
            log.error("Error claiming job for request " + request, (Throwable)e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoClaimJobResponse(e));
        }
        responseObserver.onCompleted();
    }

    public void changeJobStatus(ChangeJobStatusRequest request, StreamObserver<ChangeJobStatusResponse> responseObserver) {
        try {
            String id = request.getId();
            JobStatus currentStatus = JobStatus.valueOf((String)request.getCurrentStatus().toUpperCase());
            JobStatus newStatus = JobStatus.valueOf((String)request.getNewStatus().toUpperCase());
            String newStatusMessage = request.getNewStatusMessage();
            this.agentJobService.updateJobStatus(id, currentStatus, newStatus, newStatusMessage);
            responseObserver.onNext((Object)ChangeJobStatusResponse.newBuilder().setSuccessful(true).build());
        }
        catch (Exception e) {
            log.error("Error changing job status for request " + request, (Throwable)e);
            responseObserver.onNext((Object)this.protoErrorComposer.toProtoChangeJobStatusResponse(e));
        }
        responseObserver.onCompleted();
    }
}

