/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.netflix.genie.common.external.dtos.v4.AgentConfigRequest;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.ApplicationMetadata;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.ClusterMetadata;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.CommandMetadata;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.ExecutionEnvironment;
import com.netflix.genie.common.external.dtos.v4.ExecutionResourceCriteria;
import com.netflix.genie.common.external.dtos.v4.JobEnvironmentRequest;
import com.netflix.genie.common.external.dtos.v4.JobMetadata;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.v4.FinishedJob;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieCommandNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CriterionEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.FinishedJobProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.JobSpecificationProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.V4JobRequestProjection;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityV4DtoConverters {
    private static final Logger log = LoggerFactory.getLogger(EntityV4DtoConverters.class);

    private EntityV4DtoConverters() {
    }

    public static Application toV4ApplicationDto(ApplicationEntity applicationEntity) throws IllegalArgumentException {
        ApplicationMetadata.Builder metadataBuilder = (ApplicationMetadata.Builder)new ApplicationMetadata.Builder(applicationEntity.getName(), applicationEntity.getUser(), applicationEntity.getVersion(), DtoConverters.toV4ApplicationStatus((String)applicationEntity.getStatus())).withTags(applicationEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        applicationEntity.getType().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withType(arg_0));
        applicationEntity.getDescription().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withDescription(arg_0));
        applicationEntity.getMetadata().ifPresent(metadata -> EntityV4DtoConverters.setJsonField(metadata, arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withMetadata(arg_0)));
        return new Application(applicationEntity.getUniqueId(), applicationEntity.getCreated(), applicationEntity.getUpdated(), EntityV4DtoConverters.toExecutionEnvironment(applicationEntity.getConfigs(), applicationEntity.getDependencies(), applicationEntity.getSetupFile().orElse(null)), metadataBuilder.build());
    }

    public static Cluster toV4ClusterDto(ClusterEntity clusterEntity) throws IllegalArgumentException {
        ClusterMetadata.Builder metadataBuilder = (ClusterMetadata.Builder)new ClusterMetadata.Builder(clusterEntity.getName(), clusterEntity.getUser(), clusterEntity.getVersion(), DtoConverters.toV4ClusterStatus((String)clusterEntity.getStatus())).withTags(clusterEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        clusterEntity.getDescription().ifPresent(arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withDescription(arg_0));
        clusterEntity.getMetadata().ifPresent(metadata -> EntityV4DtoConverters.setJsonField(metadata, arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withMetadata(arg_0)));
        return new Cluster(clusterEntity.getUniqueId(), clusterEntity.getCreated(), clusterEntity.getUpdated(), EntityV4DtoConverters.toExecutionEnvironment(clusterEntity.getConfigs(), clusterEntity.getDependencies(), clusterEntity.getSetupFile().orElse(null)), metadataBuilder.build());
    }

    public static Command toV4CommandDto(CommandEntity commandEntity) throws IllegalArgumentException {
        CommandMetadata.Builder metadataBuilder = (CommandMetadata.Builder)new CommandMetadata.Builder(commandEntity.getName(), commandEntity.getUser(), commandEntity.getVersion(), DtoConverters.toV4CommandStatus((String)commandEntity.getStatus())).withTags(commandEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        commandEntity.getDescription().ifPresent(arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withDescription(arg_0));
        commandEntity.getMetadata().ifPresent(metadata -> EntityV4DtoConverters.setJsonField(metadata, arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withMetadata(arg_0)));
        return new Command(commandEntity.getUniqueId(), commandEntity.getCreated(), commandEntity.getUpdated(), EntityV4DtoConverters.toExecutionEnvironment(commandEntity.getConfigs(), commandEntity.getDependencies(), commandEntity.getSetupFile().orElse(null)), metadataBuilder.build(), commandEntity.getExecutable(), (Integer)commandEntity.getMemory().orElse(null), commandEntity.getCheckDelay(), commandEntity.getClusterCriteria().stream().map(EntityV4DtoConverters::toCriterionDto).collect(Collectors.toList()));
    }

    public static JobRequest toV4JobRequestDto(V4JobRequestProjection jobRequestProjection) {
        String requestedId = jobRequestProjection.isRequestedId() ? jobRequestProjection.getUniqueId() : null;
        JobMetadata.Builder jobMetadataBuilder = new JobMetadata.Builder(jobRequestProjection.getName(), jobRequestProjection.getUser(), jobRequestProjection.getVersion());
        jobRequestProjection.getGenieUserGroup().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withGroup(arg_0));
        jobRequestProjection.getEmail().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withEmail(arg_0));
        jobRequestProjection.getGrouping().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withGrouping(arg_0));
        jobRequestProjection.getGroupingInstance().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withGroupingInstance(arg_0));
        jobRequestProjection.getDescription().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withDescription(arg_0));
        jobMetadataBuilder.withTags(jobRequestProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        jobRequestProjection.getMetadata().ifPresent(metadata -> EntityV4DtoConverters.setJsonField(metadata, arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withMetadata(arg_0)));
        ImmutableList.Builder clusterCriteria = ImmutableList.builder();
        for (CriterionEntity criterionEntity : jobRequestProjection.getClusterCriteria()) {
            clusterCriteria.add((Object)EntityV4DtoConverters.toCriterionDto(criterionEntity));
        }
        Criterion commandCriterion = EntityV4DtoConverters.toCriterionDto(jobRequestProjection.getCommandCriterion());
        ExecutionResourceCriteria executionResourceCriteria = new ExecutionResourceCriteria((List)clusterCriteria.build(), commandCriterion, jobRequestProjection.getRequestedApplications());
        ExecutionEnvironment jobResources = EntityV4DtoConverters.toExecutionEnvironment(jobRequestProjection.getConfigs(), jobRequestProjection.getDependencies(), jobRequestProjection.getSetupFile().orElse(null));
        AgentConfigRequest.Builder agentConfigRequestBuilder = new AgentConfigRequest.Builder();
        jobRequestProjection.getRequestedAgentConfigExt().ifPresent(ext -> EntityV4DtoConverters.setJsonField(ext, arg_0 -> ((AgentConfigRequest.Builder)agentConfigRequestBuilder).withExt(arg_0)));
        jobRequestProjection.getRequestedJobDirectoryLocation().ifPresent(arg_0 -> ((AgentConfigRequest.Builder)agentConfigRequestBuilder).withRequestedJobDirectoryLocation(arg_0));
        agentConfigRequestBuilder.withInteractive(jobRequestProjection.isInteractive());
        agentConfigRequestBuilder.withArchivingDisabled(jobRequestProjection.isArchivingDisabled());
        jobRequestProjection.getRequestedTimeout().ifPresent(arg_0 -> ((AgentConfigRequest.Builder)agentConfigRequestBuilder).withTimeoutRequested(arg_0));
        JobEnvironmentRequest.Builder jobEnvironmentRequestBuilder = new JobEnvironmentRequest.Builder();
        jobRequestProjection.getRequestedAgentEnvironmentExt().ifPresent(ext -> EntityV4DtoConverters.setJsonField(ext, arg_0 -> ((JobEnvironmentRequest.Builder)jobEnvironmentRequestBuilder).withExt(arg_0)));
        jobEnvironmentRequestBuilder.withRequestedEnvironmentVariables(jobRequestProjection.getRequestedEnvironmentVariables());
        jobRequestProjection.getRequestedCpu().ifPresent(arg_0 -> ((JobEnvironmentRequest.Builder)jobEnvironmentRequestBuilder).withRequestedJobCpu(arg_0));
        jobRequestProjection.getRequestedMemory().ifPresent(arg_0 -> ((JobEnvironmentRequest.Builder)jobEnvironmentRequestBuilder).withRequestedJobMemory(arg_0));
        return new JobRequest(requestedId, jobResources, jobRequestProjection.getCommandArgs(), jobMetadataBuilder.build(), executionResourceCriteria, jobEnvironmentRequestBuilder.build(), agentConfigRequestBuilder.build());
    }

    public static Criterion toCriterionDto(CriterionEntity criterionEntity) {
        Criterion.Builder builder = new Criterion.Builder();
        criterionEntity.getUniqueId().ifPresent(arg_0 -> ((Criterion.Builder)builder).withId(arg_0));
        criterionEntity.getName().ifPresent(arg_0 -> ((Criterion.Builder)builder).withName(arg_0));
        criterionEntity.getVersion().ifPresent(arg_0 -> ((Criterion.Builder)builder).withVersion(arg_0));
        criterionEntity.getStatus().ifPresent(arg_0 -> ((Criterion.Builder)builder).withStatus(arg_0));
        builder.withTags(criterionEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        try {
            return builder.build();
        }
        catch (IllegalArgumentException iae) {
            log.error("Creating a Criterion DTO from a Criterion entity threw exception", (Throwable)iae);
            throw new GenieRuntimeException((Throwable)iae);
        }
    }

    public static FinishedJob toFinishedJobDto(FinishedJobProjection finishedJobProjection) throws IllegalArgumentException {
        FinishedJob.Builder builder = new FinishedJob.Builder(finishedJobProjection.getUniqueId(), finishedJobProjection.getName(), finishedJobProjection.getUser(), finishedJobProjection.getVersion(), finishedJobProjection.getCreated(), DtoConverters.toV4JobStatus((String)finishedJobProjection.getStatus()), finishedJobProjection.getCommandArgs(), EntityV4DtoConverters.toCriterionDto(finishedJobProjection.getCommandCriterion()), finishedJobProjection.getClusterCriteria().stream().map(EntityV4DtoConverters::toCriterionDto).collect(Collectors.toList()));
        finishedJobProjection.getStarted().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withStarted(arg_0));
        finishedJobProjection.getFinished().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withFinished(arg_0));
        finishedJobProjection.getDescription().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withDescription(arg_0));
        finishedJobProjection.getGrouping().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withGrouping(arg_0));
        finishedJobProjection.getGroupingInstance().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withGroupingInstance(arg_0));
        finishedJobProjection.getStatusMsg().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withStatusMessage(arg_0));
        finishedJobProjection.getRequestedMemory().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestedMemory(arg_0));
        finishedJobProjection.getRequestApiClientHostname().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestApiClientHostname(arg_0));
        finishedJobProjection.getRequestApiClientUserAgent().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestApiClientUserAgent(arg_0));
        finishedJobProjection.getRequestAgentClientHostname().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestAgentClientHostname(arg_0));
        finishedJobProjection.getRequestAgentClientVersion().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestAgentClientVersion(arg_0));
        finishedJobProjection.getNumAttachments().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withNumAttachments(arg_0));
        finishedJobProjection.getExitCode().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withExitCode(arg_0));
        finishedJobProjection.getArchiveLocation().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withArchiveLocation(arg_0));
        finishedJobProjection.getMemoryUsed().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withMemoryUsed(arg_0));
        builder.withTags(finishedJobProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        finishedJobProjection.getMetadata().ifPresent(metadata -> EntityV4DtoConverters.setJsonField(metadata, arg_0 -> ((FinishedJob.Builder)builder).withMetadata(arg_0)));
        finishedJobProjection.getCommand().ifPresent(commandEntity -> builder.withCommand(EntityV4DtoConverters.toV4CommandDto(commandEntity)));
        finishedJobProjection.getCluster().ifPresent(clusterEntity -> builder.withCluster(EntityV4DtoConverters.toV4ClusterDto(clusterEntity)));
        builder.withApplications(finishedJobProjection.getApplications().stream().map(EntityV4DtoConverters::toV4ApplicationDto).collect(Collectors.toList()));
        return builder.build();
    }

    static void setJsonField(String json, Consumer<JsonNode> consumer) {
        try {
            consumer.accept(GenieObjectMapper.getMapper().readTree(json));
        }
        catch (IOException ioe) {
            log.error("Reading JSON string {} into JSON node failed with error {}", new Object[]{json, ioe.getMessage(), ioe});
            consumer.accept(null);
        }
    }

    public static void setJsonField(@Nullable JsonNode json, Consumer<String> consumer) {
        if (json != null) {
            try {
                consumer.accept(GenieObjectMapper.getMapper().writeValueAsString((Object)json));
            }
            catch (JsonProcessingException jpe) {
                log.error("Unable to write JSON node {} as string due to {}", new Object[]{json, jpe.getMessage(), jpe});
                consumer.accept("{\"jsonProcessingException\": \"" + jpe.getMessage() + "\"}");
            }
        } else {
            consumer.accept(null);
        }
    }

    public static JobSpecification toJobSpecificationDto(JobSpecificationProjection jobSpecificationProjection) {
        String id = jobSpecificationProjection.getUniqueId();
        ClusterEntity clusterEntity = jobSpecificationProjection.getCluster().orElseThrow(() -> new GenieClusterNotFoundException("No cluster found for job " + id + ". Was expected to exist."));
        CommandEntity commandEntity = jobSpecificationProjection.getCommand().orElseThrow(() -> new GenieCommandNotFoundException("No command found for job " + id + ". Was expected to exist."));
        File jobDirectoryLocation = jobSpecificationProjection.getJobDirectoryLocation().map(File::new).orElseThrow(() -> new GenieRuntimeException("No job directory location available for job " + id + ". Was expected to exist"));
        String archiveLocation = jobSpecificationProjection.getArchiveLocation().orElse(null);
        JobSpecification.ExecutionResource job = EntityV4DtoConverters.toExecutionResource(id, jobSpecificationProjection.getConfigs(), jobSpecificationProjection.getDependencies(), jobSpecificationProjection.getSetupFile().orElse(null));
        JobSpecification.ExecutionResource cluster = EntityV4DtoConverters.toExecutionResource(clusterEntity.getUniqueId(), clusterEntity.getConfigs(), clusterEntity.getDependencies(), clusterEntity.getSetupFile().orElse(null));
        JobSpecification.ExecutionResource command = EntityV4DtoConverters.toExecutionResource(commandEntity.getUniqueId(), commandEntity.getConfigs(), commandEntity.getDependencies(), commandEntity.getSetupFile().orElse(null));
        List applications = jobSpecificationProjection.getApplications().stream().map(applicationEntity -> EntityV4DtoConverters.toExecutionResource(applicationEntity.getUniqueId(), applicationEntity.getConfigs(), applicationEntity.getDependencies(), applicationEntity.getSetupFile().orElse(null))).collect(Collectors.toList());
        return new JobSpecification(commandEntity.getExecutable(), jobSpecificationProjection.getCommandArgs(), job, cluster, command, applications, jobSpecificationProjection.getEnvironmentVariables(), jobSpecificationProjection.isInteractive(), jobDirectoryLocation, archiveLocation, (Integer)jobSpecificationProjection.getTimeoutUsed().orElse(null));
    }

    private static JobSpecification.ExecutionResource toExecutionResource(String id, Set<FileEntity> configs, Set<FileEntity> dependencies, @Nullable FileEntity setupFile) {
        return new JobSpecification.ExecutionResource(id, EntityV4DtoConverters.toExecutionEnvironment(configs, dependencies, setupFile));
    }

    private static ExecutionEnvironment toExecutionEnvironment(Set<FileEntity> configs, Set<FileEntity> dependencies, @Nullable FileEntity setupFile) {
        return new ExecutionEnvironment(configs.stream().map(FileEntity::getFile).collect(Collectors.toSet()), dependencies.stream().map(FileEntity::getFile).collect(Collectors.toSet()), setupFile != null ? setupFile.getFile() : null);
    }
}

