/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.web.jobs.AdminResources;
import com.netflix.genie.web.jobs.FileType;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.impl.GenieBaseTask;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTask
extends GenieBaseTask {
    private static final Logger log = LoggerFactory.getLogger(ApplicationTask.class);
    private static final String APPLICATION_TASK_TIMER_NAME = "genie.jobs.tasks.applicationTask.timer";
    private static final String APPLICATION_SETUP_TIMER_NAME = "genie.jobs.tasks.applicationTask.applicationSetup.timer";
    private final GenieFileTransferService fts;

    public ApplicationTask(@NotNull MeterRegistry registry, @NotNull GenieFileTransferService fts) {
        super(registry);
        this.fts = fts;
    }

    @Override
    public void executeTask(@NotNull Map<String, Object> context) throws GenieException, IOException {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            JobExecutionEnvironment jobExecEnv = (JobExecutionEnvironment)context.get("jee");
            String jobWorkingDirectory = jobExecEnv.getJobWorkingDir().getCanonicalPath();
            String genieDir = jobWorkingDirectory + "/" + "genie";
            Writer writer = (Writer)context.get("writer");
            log.info("Starting Application Task for job {}", (Object)jobExecEnv.getJobRequest().getId().orElse("<no id>"));
            for (Application application : jobExecEnv.getApplications()) {
                long applicationStart = System.nanoTime();
                HashSet applicationTags = Sets.newHashSet();
                applicationTags.add(Tag.of((String)"applicationId", (String)application.getId()));
                applicationTags.add(Tag.of((String)"applicationName", (String)application.getMetadata().getName()));
                try {
                    String localPath;
                    String applicationSetupFile;
                    String applicationId = application.getId();
                    this.createEntityInstanceDirectory(genieDir, applicationId, AdminResources.APPLICATION);
                    this.createEntityInstanceConfigDirectory(genieDir, applicationId, AdminResources.APPLICATION);
                    this.createEntityInstanceDependenciesDirectory(genieDir, applicationId, AdminResources.APPLICATION);
                    Optional setupFile = application.getResources().getSetupFile();
                    if (setupFile.isPresent() && StringUtils.isNotBlank((CharSequence)(applicationSetupFile = (String)setupFile.get()))) {
                        String localPath2 = super.buildLocalFilePath(jobWorkingDirectory, applicationId, applicationSetupFile, FileType.SETUP, AdminResources.APPLICATION);
                        this.fts.getFile(applicationSetupFile, localPath2);
                        super.generateSetupFileSourceSnippet(applicationId, "Application:", localPath2, writer, jobWorkingDirectory);
                    }
                    for (String dependencyFile : application.getResources().getDependencies()) {
                        localPath = super.buildLocalFilePath(jobWorkingDirectory, applicationId, dependencyFile, FileType.DEPENDENCIES, AdminResources.APPLICATION);
                        this.fts.getFile(dependencyFile, localPath);
                    }
                    for (String configFile : application.getResources().getConfigs()) {
                        localPath = super.buildLocalFilePath(jobWorkingDirectory, applicationId, configFile, FileType.CONFIG, AdminResources.APPLICATION);
                        this.fts.getFile(configFile, localPath);
                    }
                    MetricsUtils.addSuccessTags(applicationTags);
                }
                catch (Throwable t) {
                    MetricsUtils.addFailureTagsWithException(applicationTags, t);
                    throw t;
                }
                finally {
                    long applicationFinish = System.nanoTime();
                    this.getRegistry().timer(APPLICATION_SETUP_TIMER_NAME, (Iterable)applicationTags).record(applicationFinish - applicationStart, TimeUnit.NANOSECONDS);
                }
            }
            log.info("Finished Application Task for job {}", (Object)jobExecEnv.getJobRequest().getId().orElse("<no id>"));
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.getRegistry().timer(APPLICATION_TASK_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

