/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.jobs.AdminResources;
import com.netflix.genie.web.jobs.FileType;
import com.netflix.genie.web.jobs.workflow.WorkflowTask;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenieBaseTask
implements WorkflowTask {
    private static final Logger log = LoggerFactory.getLogger(GenieBaseTask.class);
    static final String NO_ID_FOUND = "<no id>";
    private final MeterRegistry registry;

    GenieBaseTask(MeterRegistry registry) {
        this.registry = registry;
    }

    protected String buildLocalFilePath(@NotBlank String dir, @NotBlank String id, @NotBlank String filePath, @NotNull FileType fileType, @NotNull AdminResources adminResources) {
        String entityPathVar = null;
        String filePathVar = null;
        switch (adminResources) {
            case APPLICATION: {
                entityPathVar = "applications";
                break;
            }
            case COMMAND: {
                entityPathVar = "command";
                break;
            }
            case CLUSTER: {
                entityPathVar = "cluster";
                break;
            }
        }
        switch (fileType) {
            case CONFIG: {
                filePathVar = "config";
                break;
            }
            case SETUP: {
                break;
            }
            case DEPENDENCIES: {
                filePathVar = "dependencies";
                break;
            }
        }
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
        StringBuilder localPath = new StringBuilder().append(dir).append("/").append("genie");
        localPath.append("/").append(entityPathVar);
        localPath.append("/").append(id);
        if (filePathVar != null) {
            localPath.append("/").append(filePathVar);
        }
        localPath.append("/").append(fileName);
        return localPath.toString();
    }

    void createEntityInstanceDirectory(@NotBlank String genieDir, @NotBlank String id, @NotNull AdminResources adminResources) throws GenieException {
        String entityPathVar = null;
        switch (adminResources) {
            case APPLICATION: {
                entityPathVar = "applications";
                break;
            }
            case COMMAND: {
                entityPathVar = "command";
                break;
            }
            case CLUSTER: {
                entityPathVar = "cluster";
                break;
            }
        }
        this.createDirectory(genieDir + "/" + entityPathVar + "/" + id);
    }

    void createEntityInstanceConfigDirectory(@NotBlank String genieDir, @NotBlank String id, @NotNull AdminResources adminResources) throws GenieException {
        String entityPathVar = null;
        switch (adminResources) {
            case APPLICATION: {
                entityPathVar = "applications";
                break;
            }
            case COMMAND: {
                entityPathVar = "command";
                break;
            }
            case CLUSTER: {
                entityPathVar = "cluster";
                break;
            }
        }
        this.createDirectory(genieDir + "/" + entityPathVar + "/" + id + "/" + "config");
    }

    void createEntityInstanceDependenciesDirectory(@NotBlank String genieDir, @NotBlank String id, @NotNull AdminResources adminResources) throws GenieException {
        String entityPathVar = null;
        switch (adminResources) {
            case APPLICATION: {
                entityPathVar = "applications";
                break;
            }
            case COMMAND: {
                entityPathVar = "command";
                break;
            }
            case CLUSTER: {
                entityPathVar = "cluster";
                break;
            }
        }
        this.createDirectory(genieDir + "/" + entityPathVar + "/" + id + "/" + "dependencies");
    }

    void createDirectory(@NotBlank(message="Directory path cannot be blank.") @NotBlank(message="Directory path cannot be blank.") String dirPath) throws GenieException {
        File dir = new File(dirPath);
        if (!dir.mkdirs()) {
            throw new GenieServerException("Could not create directory: " + dirPath);
        }
    }

    void generateSetupFileSourceSnippet(String id, String type, String filePath, Writer writer, String jobWorkingDirectory) throws IOException {
        writer.write("# Sourcing setup file from " + type + " " + id + System.lineSeparator());
        writer.write("source " + filePath.replace(jobWorkingDirectory, "${GENIE_JOB_DIR}") + System.lineSeparator());
        writer.write(System.lineSeparator());
    }

    protected MeterRegistry getRegistry() {
        return this.registry;
    }
}

