/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.web.exceptions.checked.ScriptExecutionException;
import com.netflix.genie.web.exceptions.checked.ScriptNotConfiguredException;
import com.netflix.genie.web.scripts.ExecutionModeFilterScript;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class JobExecutionModeSelector {
    private static final Logger log = LoggerFactory.getLogger(JobExecutionModeSelector.class);
    private static final String PROPERTY_PREFIX = "genie.jobs.agent-execution.";
    private static final Boolean DEFAULT_EXECUTE_WITH_AGENT = false;
    private static final String FORCE_AGENT_EXECUTION_HEADER_NAME = "genie-force-agent-execution";
    private static final String FORCE_EMBEDDED_EXECUTION_HEADER_NAME = "genie-force-embedded-execution";
    private static final String GLOBAL_AGENT_OVERRIDE_PROPERTY = "genie.jobs.agent-execution.force-agent";
    private static final String GLOBAL_EMBEDDED_OVERRIDE_PROPERTY = "genie.jobs.agent-execution.force-embedded";
    private static final String AGENT_PROBABILITY_PROPERTY = "genie.jobs.agent-execution.agent-probability";
    private static final String METRIC_NAME = "genie.jobs.executionMode.counter";
    private static final String OUTCOME_METRIC_TAG_NAME = "executeWithAgent";
    private static final String CHECK_METRIC_TAG_NAME = "decidingCheck";
    private static final String DEFAULT = "default";
    @VisibleForTesting
    public static final String DEFAULT_EXECUTE_WITH_AGENT_PROPERTY = "genie.jobs.agent-execution.default";
    private final Environment environment;
    private final Random random;
    @Nullable
    private final ExecutionModeFilterScript executionModeFilterScript;
    private final MeterRegistry meterRegistry;
    private final List<Pair<String, CheckRequestFunction>> checks = ImmutableList.of((Object)new ImmutablePair((Object)"global-override", this::checkGlobalOverride), (Object)new ImmutablePair((Object)"header-override", this::checkForcingHeader), (Object)new ImmutablePair((Object)"filter-script", this::checkFilterScript), (Object)new ImmutablePair((Object)"percentage", this::checkProbability));

    public JobExecutionModeSelector(Environment environment, MeterRegistry meterRegistry, @Nullable ExecutionModeFilterScript executionModeFilterScript) {
        this(new Random(), environment, meterRegistry, executionModeFilterScript);
    }

    @VisibleForTesting
    JobExecutionModeSelector(Random random, Environment environment, MeterRegistry meterRegistry, @Nullable ExecutionModeFilterScript executionModeFilterScript) {
        this.environment = environment;
        this.random = random;
        this.meterRegistry = meterRegistry;
        this.executionModeFilterScript = executionModeFilterScript;
    }

    public boolean executeWithAgent(JobRequest jobRequest, HttpServletRequest httpServletRequest) {
        for (Pair<String, CheckRequestFunction> nameFunctionCheckPair : this.checks) {
            String checkName = (String)nameFunctionCheckPair.getKey();
            CheckRequestFunction checkFunction = (CheckRequestFunction)nameFunctionCheckPair.getValue();
            Optional<Boolean> checkOptionalOutcome = checkFunction.check(jobRequest, httpServletRequest);
            if (!checkOptionalOutcome.isPresent()) continue;
            boolean executeWithAgent = checkOptionalOutcome.get();
            this.publishMetric(executeWithAgent, checkName);
            return executeWithAgent;
        }
        boolean executeWithAgent = (Boolean)this.environment.getProperty(DEFAULT_EXECUTE_WITH_AGENT_PROPERTY, Boolean.class, (Object)DEFAULT_EXECUTE_WITH_AGENT);
        this.publishMetric(executeWithAgent, DEFAULT);
        return executeWithAgent;
    }

    private Optional<Boolean> checkGlobalOverride(JobRequest jobRequest, HttpServletRequest httpServletRequest) {
        if (((Boolean)this.environment.getProperty(GLOBAL_AGENT_OVERRIDE_PROPERTY, Boolean.class, (Object)false)).booleanValue()) {
            log.debug("Forcing agent execution globally");
            return Optional.of(true);
        }
        if (((Boolean)this.environment.getProperty(GLOBAL_EMBEDDED_OVERRIDE_PROPERTY, Boolean.class, (Object)false)).booleanValue()) {
            log.debug("Forcing embedded execution globally");
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private Optional<Boolean> checkForcingHeader(JobRequest jobRequest, HttpServletRequest httpServletRequest) {
        if (Boolean.parseBoolean(httpServletRequest.getHeader(FORCE_AGENT_EXECUTION_HEADER_NAME))) {
            log.debug("Forcing agent execution as per request header");
            return Optional.of(true);
        }
        if (Boolean.parseBoolean(httpServletRequest.getHeader(FORCE_EMBEDDED_EXECUTION_HEADER_NAME))) {
            log.debug("Forcing embedded execution as per request header");
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private Optional<Boolean> checkProbability(JobRequest jobRequest, HttpServletRequest httpServletRequest) {
        String agentExecutionProbabilityString = this.environment.getProperty(AGENT_PROBABILITY_PROPERTY);
        if (StringUtils.isBlank((CharSequence)agentExecutionProbabilityString)) {
            return Optional.empty();
        }
        float agentExecutionProbability = Float.parseFloat(agentExecutionProbabilityString);
        if ((double)agentExecutionProbability < 0.0 || (double)agentExecutionProbability > 1.0) {
            log.info("Invalid probability: {}", (Object)Float.valueOf(agentExecutionProbability));
            return Optional.empty();
        }
        if (this.random.nextFloat() < agentExecutionProbability) {
            log.debug("Job randomly selected for agent execution");
            return Optional.of(true);
        }
        log.debug("Job randomly selected for embedded execution");
        return Optional.of(false);
    }

    private Optional<Boolean> checkFilterScript(JobRequest jobRequest, HttpServletRequest httpServletRequest) {
        if (this.executionModeFilterScript != null) {
            try {
                return this.executionModeFilterScript.forceAgentExecution(jobRequest);
            }
            catch (ScriptExecutionException | ScriptNotConfiguredException e) {
                log.error("Script filter error: " + e.getMessage(), (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private void publishMetric(boolean executeWithAgent, String checkName) {
        log.info("Job designated for {} execution by check: {}", (Object)(executeWithAgent ? "agent" : "embedded"), (Object)checkName);
        this.meterRegistry.counter(METRIC_NAME, (Iterable)Sets.newHashSet((Object[])new Tag[]{Tag.of((String)OUTCOME_METRIC_TAG_NAME, (String)String.valueOf(executeWithAgent)), Tag.of((String)CHECK_METRIC_TAG_NAME, (String)checkName)})).increment();
    }

    @FunctionalInterface
    private static interface CheckRequestFunction {
        public Optional<Boolean> check(JobRequest var1, HttpServletRequest var2);
    }
}

