/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.services.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.genie.common.internal.util.ExponentialBackOffTrigger;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public class AgentRoutingServiceCuratorDiscoveryImpl
implements AgentRoutingService {
    private static final Logger log = LoggerFactory.getLogger(AgentRoutingServiceCuratorDiscoveryImpl.class);
    private static final String SERVICE_NAME = "agent_connections";
    private static final String METRICS_PREFIX = "genie.agents.connections.";
    private static final String CONNECTED_AGENTS_GAUGE_NAME = "genie.agents.connections.connected.gauge";
    private static final String REGISTERED_AGENTS_GAUGE_NAME = "genie.agents.connections.registered.gauge";
    private static final String ZOOKEEPER_SESSION_STATE_COUNTER_NAME = "genie.agents.connections.zookeeperSessionState.counter";
    private static final String AGENT_REGISTERED_TIMER_NAME = "genie.agents.connections.registered.timer";
    private static final String AGENT_UNREGISTERED_TIMER_NAME = "genie.agents.connections.unregistered.timer";
    private static final String AGENT_REFRESH_TIMER_NAME = "genie.agents.connections.refreshed.timer";
    private static final String AGENT_CONNECTED_COUNTER_NAME = "genie.agents.connections.connected.counter";
    private static final String AGENT_DISCONNECTED_COUNTER_NAME = "genie.agents.connections.disconnected.counter";
    private static final String ZK_CONNECTION_STATE_TAG_NAME = "connectionState";
    private static final Set<Tag> EMPTY_TAG_SET = ImmutableSet.of();
    private final String localHostname;
    private final ServiceDiscovery<Agent> serviceDiscovery;
    private final TaskScheduler taskScheduler;
    private final MeterRegistry registry;
    private final Set<String> connectedAgentsSet = Sets.newConcurrentHashSet();
    private final Map<String, ServiceInstance<Agent>> registeredAgentsMap = Maps.newConcurrentMap();
    private final ExponentialBackOffTrigger trigger = new ExponentialBackOffTrigger(ExponentialBackOffTrigger.DelayType.FROM_PREVIOUS_EXECUTION_COMPLETION, 100L, 5000L, 1.2f);

    public AgentRoutingServiceCuratorDiscoveryImpl(GenieHostInfo genieHostInfo, ServiceDiscovery<Agent> serviceDiscovery, TaskScheduler taskScheduler, Listenable<ConnectionStateListener> listenableCuratorConnectionState, MeterRegistry registry) {
        this.localHostname = genieHostInfo.getHostname();
        this.serviceDiscovery = serviceDiscovery;
        this.taskScheduler = taskScheduler;
        this.registry = registry;
        this.taskScheduler.schedule(this::reconcileRegistrationsTask, (Trigger)this.trigger);
        listenableCuratorConnectionState.addListener(this::handleConnectionStateChange);
        registry.gauge(CONNECTED_AGENTS_GAUGE_NAME, EMPTY_TAG_SET, this.connectedAgentsSet, Set::size);
        registry.gaugeMapSize(REGISTERED_AGENTS_GAUGE_NAME, EMPTY_TAG_SET, this.registeredAgentsMap);
    }

    private void handleConnectionStateChange(CuratorFramework client, ConnectionState newState) {
        this.registry.counter(ZOOKEEPER_SESSION_STATE_COUNTER_NAME, (Iterable)Sets.newHashSet((Object[])new Tag[]{Tag.of((String)ZK_CONNECTION_STATE_TAG_NAME, (String)newState.name())})).increment();
        switch (newState) {
            case CONNECTED: {
                log.info("Zookeeper/Curator connected (or re-connected)");
                this.taskScheduler.schedule(this::reconcileRegistrationsTask, Instant.now());
                break;
            }
            case LOST: {
                log.info("Zookeeper/Curator session expired, all instances will need to re-register");
                this.registeredAgentsMap.clear();
                break;
            }
            default: {
                log.debug("Zookeeper/Curator connection state changed to: {}", (Object)newState);
            }
        }
    }

    private synchronized void reconcileRegistrationsTask() {
        try {
            this.reconcileRegistrations();
        }
        catch (Exception e) {
            log.error("Unexpected exception in reconciliation task", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileRegistrations() {
        long start;
        ServiceInstance serviceInstance;
        String jobId;
        boolean anyChange = false;
        for (String string : this.connectedAgentsSet) {
            if (this.registeredAgentsMap.containsKey(string)) continue;
            ServiceInstance serviceInstance2 = new ServiceInstance(SERVICE_NAME, string, this.localHostname, null, null, (Object)new Agent(string), Instant.now().getEpochSecond(), ServiceType.DYNAMIC, null);
            Set<Tag> tags = MetricsUtils.newSuccessTagsSet();
            long start2 = System.nanoTime();
            try {
                this.serviceDiscovery.registerService(serviceInstance2);
                this.registeredAgentsMap.put(string, (ServiceInstance<Agent>)serviceInstance2);
                anyChange = true;
            }
            catch (Exception e) {
                log.error("Failed to register agent executing job: {}", (Object)string, (Object)e);
                tags = MetricsUtils.newFailureTagsSetForException(e);
            }
            finally {
                this.registry.timer(AGENT_REGISTERED_TIMER_NAME, tags).record(System.nanoTime() - start2, TimeUnit.NANOSECONDS);
            }
        }
        for (Map.Entry entry : this.registeredAgentsMap.entrySet()) {
            if (this.connectedAgentsSet.contains(entry.getKey())) continue;
            jobId = (String)entry.getKey();
            serviceInstance = (ServiceInstance)entry.getValue();
            Set<Tag> tags = MetricsUtils.newSuccessTagsSet();
            start = System.nanoTime();
            try {
                this.serviceDiscovery.unregisterService(serviceInstance);
                this.registeredAgentsMap.remove(jobId);
                anyChange = true;
            }
            catch (Exception e) {
                log.error("Failed to unregister agent executing job id: {}", (Object)jobId);
                tags = MetricsUtils.newFailureTagsSetForException(e);
            }
            finally {
                this.registry.timer(AGENT_UNREGISTERED_TIMER_NAME, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
        for (Map.Entry entry : this.registeredAgentsMap.entrySet()) {
            if (!this.connectedAgentsSet.contains(entry.getKey())) continue;
            jobId = (String)entry.getKey();
            serviceInstance = (ServiceInstance)entry.getValue();
            Set<Tag> tags = MetricsUtils.newSuccessTagsSet();
            start = System.nanoTime();
            try {
                this.serviceDiscovery.updateService(serviceInstance);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn("Failed to update registration of agent executing job id: {}", (Object)jobId);
                try {
                    this.serviceDiscovery.registerService(serviceInstance);
                }
                catch (Exception exception) {
                    log.error("Failed to re-create registration for agent executing job id: {}", (Object)jobId);
                    tags = MetricsUtils.newFailureTagsSetForException(e);
                }
            }
            catch (Exception e) {
                log.error("Failed to refresh agent executing job id: {}", (Object)jobId);
                tags = MetricsUtils.newFailureTagsSetForException(e);
            }
            finally {
                this.registry.timer(AGENT_REFRESH_TIMER_NAME, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
        if (anyChange) {
            this.trigger.reset();
        }
    }

    @Override
    public void handleClientConnected(@NotBlank String jobId) {
        this.registry.counter(AGENT_CONNECTED_COUNTER_NAME, EMPTY_TAG_SET).increment();
        this.connectedAgentsSet.add(jobId);
    }

    @Override
    public void handleClientDisconnected(@NotBlank String jobId) {
        this.registry.counter(AGENT_DISCONNECTED_COUNTER_NAME, EMPTY_TAG_SET).increment();
        this.connectedAgentsSet.remove(jobId);
    }

    @Override
    public Optional<String> getHostnameForAgentConnection(@NotBlank String jobId) {
        ServiceInstance instance;
        log.debug("Looking up agent executing job: {}", (Object)jobId);
        if (this.isAgentConnectionLocal(jobId)) {
            return Optional.of(this.localHostname);
        }
        try {
            instance = this.serviceDiscovery.queryForInstance(SERVICE_NAME, jobId);
        }
        catch (Exception e) {
            log.error("Error looking up agent connection for job {}", (Object)jobId, (Object)e);
            return Optional.empty();
        }
        if (instance == null) {
            log.debug("Could not find agent connection for job {}", (Object)jobId);
            return Optional.empty();
        }
        return Optional.ofNullable(instance.getAddress());
    }

    @Override
    public boolean isAgentConnectionLocal(@NotBlank String jobId) {
        return this.connectedAgentsSet.contains(jobId);
    }

    @Override
    public boolean isAgentConnected(String jobId) {
        return this.getHostnameForAgentConnection(jobId).isPresent();
    }

    public static final class Agent {
        private final String jobId;

        private Agent() {
            this.jobId = null;
        }

        public Agent(@JsonProperty(value="jobId", required=true) String jobId) {
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Agent)) {
                return false;
            }
            Agent other = (Agent)o;
            String this$jobId = this.getJobId();
            String other$jobId = other.getJobId();
            return !(this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jobId = this.getJobId();
            result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
            return result;
        }
    }
}

