/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.ClusterCriteria;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.impl.GenieBaseTask;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialSetupTask
extends GenieBaseTask {
    private static final Logger log = LoggerFactory.getLogger(InitialSetupTask.class);
    static final String SETUP_TASK_TIMER_NAME = "genie.jobs.tasks.initialSetupTask.timer";
    private static final String GENIE_VERSION_EXPORT = "export GENIE_VERSION=3";
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public InitialSetupTask(@NotNull MeterRegistry registry) {
        super(registry);
    }

    @Override
    public void executeTask(@NotNull Map<String, Object> context) throws GenieException, IOException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            JobExecutionEnvironment jobExecEnv = (JobExecutionEnvironment)context.get("jee");
            String jobWorkingDirectory = jobExecEnv.getJobWorkingDir().getCanonicalPath();
            Writer writer = (Writer)context.get("writer");
            String jobId = (String)jobExecEnv.getJobRequest().getId().orElseThrow(() -> new GeniePreconditionException("No job id found. Unable to continue"));
            log.info("Starting Initial Setup Task for job {}", (Object)jobId);
            this.createJobDirStructure(jobWorkingDirectory);
            this.createJobDirEnvironmentVariables(writer, jobWorkingDirectory);
            this.createApplicationEnvironmentVariables(writer);
            Command command = jobExecEnv.getCommand();
            this.createCommandEnvironmentVariables(writer, command);
            Cluster cluster = jobExecEnv.getCluster();
            this.createClusterEnvironmentVariables(writer, cluster);
            this.createJobEnvironmentVariables(writer, jobId, jobExecEnv.getJobRequest().getName(), jobExecEnv.getMemory(), jobExecEnv.getJobRequest().getTags(), jobExecEnv.getJobRequest().getGrouping().orElse(""), jobExecEnv.getJobRequest().getGroupingInstance().orElse(""), jobExecEnv.getJobRequest().getUser(), jobExecEnv.getJobRequest().getGroup().orElse(""));
            this.createJobRequestEnvironmentVariables(writer, jobExecEnv.getJobRequest());
            writer.write(GENIE_VERSION_EXPORT);
            writer.write(LINE_SEPARATOR);
            writer.write(LINE_SEPARATOR);
            log.info("Finished Initial Setup Task for job {}", (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.getRegistry().timer(SETUP_TASK_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @VisibleForTesting
    void createJobDirStructure(String jobWorkingDirectory) throws GenieException, IOException {
        this.createDirectory(jobWorkingDirectory + "/" + "genie");
        this.createDirectory(jobWorkingDirectory + "/" + "genie" + "/" + "logs");
        this.createDirectory(jobWorkingDirectory + "/" + "genie" + "/" + "applications");
        this.createDirectory(jobWorkingDirectory + "/" + "genie" + "/" + "command");
        this.createDirectory(jobWorkingDirectory + "/" + "genie" + "/" + "cluster");
        File stdout = new File(jobWorkingDirectory, "stdout");
        if (!stdout.exists() && !stdout.createNewFile()) {
            throw new GenieServerException("Unable to create std out file at " + stdout);
        }
        File stderr = new File(jobWorkingDirectory, "stderr");
        if (!stderr.exists() && !stderr.createNewFile()) {
            throw new GenieServerException("Unable to create std err file at " + stderr);
        }
    }

    @VisibleForTesting
    void createJobDirEnvironmentVariables(Writer writer, String jobWorkingDirectory) throws IOException {
        writer.write("export GENIE_JOB_DIR=\"" + jobWorkingDirectory + "\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
    }

    @VisibleForTesting
    void createApplicationEnvironmentVariables(Writer writer) throws IOException {
        writer.write("export GENIE_APPLICATION_DIR=\"${GENIE_JOB_DIR}/genie/applications\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
    }

    @VisibleForTesting
    void createCommandEnvironmentVariables(Writer writer, Command command) throws IOException {
        String commandId = command.getId();
        writer.write("export GENIE_COMMAND_DIR=\"${GENIE_JOB_DIR}/genie/command/" + commandId + "\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("export GENIE_COMMAND_ID=\"" + commandId + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
        writer.write("export GENIE_COMMAND_NAME=\"" + command.getMetadata().getName() + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
        writer.write("export GENIE_COMMAND_TAGS=\"" + this.tagsToString((Set<String>)DtoConverters.toV3Tags((String)command.getId(), (String)command.getMetadata().getName(), (Set)command.getMetadata().getTags())) + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
    }

    @VisibleForTesting
    void createClusterEnvironmentVariables(Writer writer, Cluster cluster) throws IOException {
        String clusterId = cluster.getId();
        writer.write("export GENIE_CLUSTER_DIR=\"${GENIE_JOB_DIR}/genie/cluster/" + clusterId + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
        writer.write("export GENIE_CLUSTER_ID=\"" + clusterId + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
        writer.write("export GENIE_CLUSTER_NAME=\"" + cluster.getMetadata().getName() + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
        writer.write("export GENIE_CLUSTER_TAGS=\"" + this.tagsToString((Set<String>)DtoConverters.toV3Tags((String)cluster.getId(), (String)cluster.getMetadata().getName(), (Set)cluster.getMetadata().getTags())) + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
    }

    @VisibleForTesting
    void createJobEnvironmentVariables(Writer writer, String jobId, String jobName, int memory, Set<String> tags, String grouping, String groupingInstance, String user, String group) throws IOException {
        writer.write("export GENIE_JOB_ID=\"" + jobId + "\"" + LINE_SEPARATOR);
        writer.write(System.lineSeparator());
        writer.write("export GENIE_JOB_NAME=\"" + jobName + "\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("export GENIE_JOB_MEMORY=" + memory + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("export GENIE_JOB_TAGS=\"" + this.tagsToString(tags) + "\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("export GENIE_JOB_GROUPING=\"" + grouping + "\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("export GENIE_JOB_GROUPING_INSTANCE=\"" + groupingInstance + "\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("export GENIE_USER=\"" + user + "\"" + LINE_SEPARATOR);
        writer.write("export GENIE_USER_GROUP=\"" + group + "\"" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
    }

    @VisibleForTesting
    void createJobRequestEnvironmentVariables(Writer writer, JobRequest jobRequest) throws IOException {
        writer.write("export GENIE_REQUESTED_COMMAND_TAGS=\"" + this.tagsToString(jobRequest.getCommandCriteria()) + "\"" + LINE_SEPARATOR);
        List clusterCriterias = jobRequest.getClusterCriterias();
        ArrayList<String> clusterCriteriasStrings = new ArrayList<String>(clusterCriterias.size());
        for (ClusterCriteria clusterCriteria : clusterCriterias) {
            clusterCriteriasStrings.add("[" + this.tagsToString(clusterCriteria.getTags()) + "]");
        }
        writer.write(System.lineSeparator());
        writer.write("export GENIE_REQUESTED_CLUSTER_TAGS=\"[" + StringUtils.join(clusterCriteriasStrings, (char)',') + "]" + "\"" + LINE_SEPARATOR);
        for (int i = 0; i < clusterCriterias.size(); ++i) {
            ClusterCriteria clusterCriteria;
            clusterCriteria = (ClusterCriteria)clusterCriterias.get(i);
            writer.write("export GENIE_REQUESTED_CLUSTER_TAGS_" + i + "=" + "\"" + this.tagsToString(clusterCriteria.getTags()) + "\"" + LINE_SEPARATOR);
        }
        writer.write(LINE_SEPARATOR);
    }

    @VisibleForTesting
    String tagsToString(Set<String> tags) {
        ArrayList sortedTags = new ArrayList(tags == null ? Collections.emptySet() : tags);
        sortedTags.sort(Comparator.naturalOrder());
        String joinedString = StringUtils.join(sortedTags, (char)',');
        return RegExUtils.replaceAll((String)RegExUtils.replaceAll((String)joinedString, (String)"'", (String)"\\'"), (String)"\"", (String)"\\\"");
    }
}

