/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.services.FileTransferFactory;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.services.impl.LocalFileTransferImpl;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheGenieFileTransferService
extends GenieFileTransferService {
    private static final Logger log = LoggerFactory.getLogger(CacheGenieFileTransferService.class);
    private final String baseCacheLocation;
    private final LocalFileTransferImpl localFileTransfer;
    private final LoadingCache<String, File> fileCache = CacheBuilder.newBuilder().recordStats().build((CacheLoader)new CacheLoader<String, File>(){

        public File load(@NotNull String path) throws GenieException {
            return CacheGenieFileTransferService.this.loadFile(path);
        }
    });

    public CacheGenieFileTransferService(@NotNull FileTransferFactory fileTransferFactory, @NotNull String baseCacheLocation, @NotNull LocalFileTransferImpl localFileTransfer, @NotNull MeterRegistry registry) throws GenieException {
        super(fileTransferFactory);
        this.baseCacheLocation = this.createDirectories(baseCacheLocation).toString();
        this.localFileTransfer = localFileTransfer;
        registry.gauge("genie.jobs.file.cache.hitRate", this.fileCache, value -> value.stats().hitRate());
        registry.gauge("genie.jobs.file.cache.missRate", this.fileCache, value -> value.stats().missRate());
        registry.gauge("genie.jobs.file.cache.loadExceptionRate", this.fileCache, value -> value.stats().loadExceptionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getFile(@NotBlank(message="Source file path cannot be empty.") @NotBlank(message="Source file path cannot be empty.") String srcRemotePath, @NotBlank(message="Destination local path cannot be empty") @NotBlank(message="Destination local path cannot be empty") String dstLocalPath) throws GenieException {
        File cachedFile;
        block6: {
            log.debug("Called with src path {} and destination path {}", (Object)srcRemotePath, (Object)dstLocalPath);
            try {
                cachedFile = (File)this.fileCache.get((Object)srcRemotePath);
                long lastModifiedTime = this.getFileTransfer(srcRemotePath).getLastModifiedTime(srcRemotePath);
                if (lastModifiedTime <= cachedFile.lastModified()) break block6;
                CacheGenieFileTransferService cacheGenieFileTransferService = this;
                synchronized (cacheGenieFileTransferService) {
                    if (lastModifiedTime > cachedFile.lastModified()) {
                        this.fileCache.invalidate((Object)srcRemotePath);
                        this.deleteFile(cachedFile);
                        cachedFile = (File)this.fileCache.get((Object)srcRemotePath);
                    }
                }
            }
            catch (Exception e) {
                String message = String.format("Failed getting the file %s", srcRemotePath);
                log.error(message);
                throw new GenieServerException(message, (Throwable)e);
            }
        }
        this.localFileTransfer.getFile(cachedFile.getPath(), dstLocalPath);
    }

    protected void deleteFile(File file) throws IOException {
        Files.deleteIfExists(file.toPath());
    }

    protected Path createDirectories(String path) throws GenieException {
        try {
            File pathFile = new File(new URI(path).getPath());
            Path result = pathFile.toPath();
            if (!Files.exists(result, new LinkOption[0])) {
                Files.createDirectories(result, new FileAttribute[0]);
            }
            return result;
        }
        catch (Exception e) {
            throw new GenieServerException("Failed creating the cache location " + path, (Throwable)e);
        }
    }

    protected File loadFile(String path) throws GenieException {
        byte[] pathBytes = path.getBytes(StandardCharsets.UTF_8);
        String pathUUID = UUID.nameUUIDFromBytes(pathBytes).toString();
        String cacheFilePath = String.format("%s/%s", this.baseCacheLocation, pathUUID);
        File cacheFile = new File(cacheFilePath);
        if (!cacheFile.exists()) {
            this.getFileTransfer(path).getFile(path, cacheFilePath);
        }
        return cacheFile;
    }
}

