/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.events;

import com.amazonaws.services.sns.AmazonSNS;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.web.data.observers.PersistedJobStatusObserver;
import com.netflix.genie.web.data.observers.PersistedJobStatusObserverImpl;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.events.JobFinishedSNSPublisher;
import com.netflix.genie.web.events.JobNotificationMetricPublisher;
import com.netflix.genie.web.events.JobStateChangeSNSPublisher;
import com.netflix.genie.web.properties.SNSNotificationsProperties;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SNSNotificationsProperties.class})
public class NotificationsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PersistedJobStatusObserver.class})
    public PersistedJobStatusObserver persistedJobStatusObserver(GenieEventBus genieEventBus) {
        return new PersistedJobStatusObserverImpl(genieEventBus);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobNotificationMetricPublisher.class})
    public JobNotificationMetricPublisher jobNotificationMetricPublisher(MeterRegistry registry) {
        return new JobNotificationMetricPublisher(registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.notifications.sns.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={JobStateChangeSNSPublisher.class})
    public JobStateChangeSNSPublisher jobNotificationsSNSPublisher(SNSNotificationsProperties properties, MeterRegistry registry, AmazonSNS snsClient) {
        return new JobStateChangeSNSPublisher(snsClient, properties, registry, GenieObjectMapper.getMapper());
    }

    @Bean
    @ConditionalOnProperty(value={"genie.notifications.sns.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={JobFinishedSNSPublisher.class})
    public JobFinishedSNSPublisher jobFinishedSNSPublisher(SNSNotificationsProperties properties, MeterRegistry registry, AmazonSNS snsClient, DataServices dataServices) {
        return new JobFinishedSNSPublisher(snsClient, properties, dataServices, registry, GenieObjectMapper.getMapper());
    }
}

