/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.v4.endpoints;

import com.google.common.collect.Maps;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.proto.JobKillRegistrationRequest;
import com.netflix.genie.proto.JobKillRegistrationResponse;
import com.netflix.genie.proto.JobKillServiceGrpc;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.services.JobKillServiceV4;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcJobKillServiceImpl
extends JobKillServiceGrpc.JobKillServiceImplBase
implements JobKillServiceV4 {
    private static final Logger log = LoggerFactory.getLogger(GRpcJobKillServiceImpl.class);
    private final Map<String, StreamObserver<JobKillRegistrationResponse>> parkedJobKillResponseObservers = Maps.newConcurrentMap();
    private final PersistenceService persistenceService;

    public GRpcJobKillServiceImpl(DataServices dataServices) {
        this.persistenceService = dataServices.getPersistenceService();
    }

    public void registerForKillNotification(JobKillRegistrationRequest request, StreamObserver<JobKillRegistrationResponse> responseObserver) {
        StreamObserver<JobKillRegistrationResponse> existingObserver = this.parkedJobKillResponseObservers.put(request.getJobId(), responseObserver);
        if (existingObserver != null) {
            existingObserver.onCompleted();
        }
    }

    @Override
    public void killJob(@NotBlank(message="No job id entered. Unable to kill job.") @NotBlank(message="No job id entered. Unable to kill job.") String jobId, @NotBlank(message="No reason provided.") @NotBlank(message="No reason provided.") String reason) throws GenieException {
        StreamObserver<JobKillRegistrationResponse> responseObserver = this.parkedJobKillResponseObservers.remove(jobId);
        if (responseObserver == null) {
            log.error("Job not killed. No response observer found for killing the job with id: {} ", (Object)jobId);
            throw new GenieServerException("Job not killed. No response observer found for killing the job with id: " + jobId);
        }
        try {
            if (this.persistenceService.getJobStatus(jobId).isFinished()) {
                log.info("v4 job {} was already finished when the kill request came", (Object)jobId);
            } else {
                responseObserver.onNext((Object)JobKillRegistrationResponse.newBuilder().build());
                responseObserver.onCompleted();
                log.info("Agent notified for killing job {}", (Object)jobId);
            }
        }
        catch (NotFoundException e) {
            throw new GenieNotFoundException(e.getMessage(), (Throwable)((Object)e));
        }
    }
}

