/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.repositories;

import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaBaseRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaApplicationRepository
extends JpaBaseRepository<ApplicationEntity> {
    public static final String FIND_UNUSED_APPLICATIONS_QUERY = "SELECT id FROM applications WHERE created < :createdThreshold AND id NOT IN (SELECT DISTINCT(application_id) FROM commands_applications) AND id NOT IN (SELECT DISTINCT(application_id) FROM jobs_applications)";

    @Query(value="SELECT id FROM applications WHERE created < :createdThreshold AND id NOT IN (SELECT DISTINCT(application_id) FROM commands_applications) AND id NOT IN (SELECT DISTINCT(application_id) FROM jobs_applications)", nativeQuery=true)
    public Set<Long> findUnusedApplications(@Param(value="createdThreshold") Instant var1);

    @Query(value="SELECT a FROM ApplicationEntity a WHERE a.uniqueId = :id")
    @EntityGraph(value="Application.dto", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<ApplicationEntity> getApplicationDto(@Param(value="id") String var1);

    @Query(value="SELECT a FROM ApplicationEntity a WHERE a.uniqueId = :id")
    @EntityGraph(value="Application.commands", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<ApplicationEntity> getApplicationAndCommands(@Param(value="id") String var1);

    @Query(value="SELECT a FROM ApplicationEntity a WHERE a.uniqueId = :id")
    @EntityGraph(value="Application.commands.dto", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<ApplicationEntity> getApplicationAndCommandsDto(@Param(value="id") String var1);
}

