/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.dtos;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.common.external.dtos.v4.JobRequestMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.core.io.Resource;

public class JobSubmission {
    @NotNull
    @Valid
    private final JobRequest jobRequest;
    @NotNull
    @Valid
    private final JobRequestMetadata jobRequestMetadata;
    @NotNull
    private final Set<Resource> attachments;

    private JobSubmission(Builder builder) {
        this.jobRequest = builder.bJobRequest;
        this.jobRequestMetadata = builder.bJobRequestMetadata;
        this.attachments = ImmutableSet.copyOf((Collection)builder.bAttachments);
    }

    public JobRequest getJobRequest() {
        return this.jobRequest;
    }

    public JobRequestMetadata getJobRequestMetadata() {
        return this.jobRequestMetadata;
    }

    public Set<Resource> getAttachments() {
        return this.attachments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobSubmission)) {
            return false;
        }
        JobSubmission other = (JobSubmission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobRequest this$jobRequest = this.jobRequest;
        JobRequest other$jobRequest = other.jobRequest;
        if (this$jobRequest == null ? other$jobRequest != null : !this$jobRequest.equals(other$jobRequest)) {
            return false;
        }
        JobRequestMetadata this$jobRequestMetadata = this.jobRequestMetadata;
        JobRequestMetadata other$jobRequestMetadata = other.jobRequestMetadata;
        return !(this$jobRequestMetadata == null ? other$jobRequestMetadata != null : !this$jobRequestMetadata.equals(other$jobRequestMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobSubmission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobRequest $jobRequest = this.jobRequest;
        result = result * 59 + ($jobRequest == null ? 43 : $jobRequest.hashCode());
        JobRequestMetadata $jobRequestMetadata = this.jobRequestMetadata;
        result = result * 59 + ($jobRequestMetadata == null ? 43 : $jobRequestMetadata.hashCode());
        return result;
    }

    public String toString() {
        return "JobSubmission(jobRequest=" + this.jobRequest + ", jobRequestMetadata=" + this.jobRequestMetadata + ")";
    }

    public static class Builder {
        private final JobRequest bJobRequest;
        private final JobRequestMetadata bJobRequestMetadata;
        private final Set<Resource> bAttachments;

        public Builder(JobRequest jobRequest, JobRequestMetadata jobRequestMetadata) {
            this.bJobRequest = jobRequest;
            this.bJobRequestMetadata = jobRequestMetadata;
            this.bAttachments = Sets.newHashSet();
        }

        public Builder withAttachments(@Nullable Set<Resource> attachments) {
            this.setAttachments(attachments);
            return this;
        }

        public Builder withAttachments(Resource ... attachments) {
            this.setAttachments(Arrays.asList(attachments));
            return this;
        }

        public JobSubmission build() {
            return new JobSubmission(this);
        }

        private void setAttachments(@Nullable Collection<Resource> attachments) {
            this.bAttachments.clear();
            if (attachments != null) {
                this.bAttachments.addAll(attachments);
            }
        }
    }
}

