/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.google.common.collect.Maps;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.exceptions.checked.ScriptExecutionException;
import com.netflix.genie.web.exceptions.checked.ScriptNotConfiguredException;
import com.netflix.genie.web.scripts.ManagedScript;
import com.netflix.genie.web.scripts.ManagedScriptBaseProperties;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.scripts.ScriptManager;
import com.netflix.genie.web.selectors.ResourceSelectionContext;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSelectorScript<R, C extends ResourceSelectionContext<R>>
extends ManagedScript {
    private static final Logger log = LoggerFactory.getLogger(ResourceSelectorScript.class);
    static final String JOB_REQUEST_BINDING = "jobRequestParameter";
    static final String JOB_ID_BINDING = "jobIdParameter";
    static final String CONTEXT_BINDING = "contextParameter";

    protected ResourceSelectorScript(ScriptManager scriptManager, ManagedScriptBaseProperties properties, MeterRegistry registry) {
        super(scriptManager, properties, registry);
    }

    public ResourceSelectorScriptResult<R> selectResource(C context) throws ResourceSelectionException {
        try {
            HashMap parameters = Maps.newHashMap();
            this.addParametersForScript(parameters, context);
            Object evaluationResult = this.evaluateScript(parameters);
            if (!(evaluationResult instanceof ResourceSelectorScriptResult)) {
                throw new ResourceSelectionException("Selector evaluation returned invalid type: " + evaluationResult.getClass().getName() + " expected " + ResourceSelectorScriptResult.class.getName());
            }
            ResourceSelectorScriptResult result = (ResourceSelectorScriptResult)evaluationResult;
            if (result.getResource().isPresent() && !((ResourceSelectionContext)context).getResources().contains(result.getResource().get())) {
                throw new ResourceSelectionException(result.getResource().get() + " is not in original set");
            }
            return result;
        }
        catch (ScriptExecutionException | ScriptNotConfiguredException | RuntimeException e) {
            throw new ResourceSelectionException(e);
        }
    }

    protected void addParametersForScript(Map<String, Object> parameters, C context) {
        parameters.put(CONTEXT_BINDING, context);
        parameters.put(JOB_REQUEST_BINDING, ((ResourceSelectionContext)context).getJobRequest());
        parameters.put(JOB_ID_BINDING, ((ResourceSelectionContext)context).getJobId());
    }
}

