/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors;

import com.google.common.collect.ImmutableSet;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.web.selectors.ResourceSelectionContext;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class ClusterSelectionContext
extends ResourceSelectionContext<Cluster> {
    private final Command command;
    private final Set<Cluster> clusters;

    public ClusterSelectionContext(@NotEmpty String jobId, @NotNull JobRequest jobRequest, boolean apiJob, @Nullable @Valid Command command, @NotEmpty Set<@Valid Cluster> clusters) {
        super(jobId, jobRequest, apiJob);
        this.command = command;
        this.clusters = ImmutableSet.copyOf(clusters);
    }

    public Optional<Command> getCommand() {
        return Optional.ofNullable(this.command);
    }

    @Override
    public Set<Cluster> getResources() {
        return this.clusters;
    }

    public Set<Cluster> getClusters() {
        return this.clusters;
    }

    @Override
    public String toString() {
        return "ClusterSelectionContext(super=" + super.toString() + ", command=" + this.command + ", clusters=" + this.clusters + ")";
    }
}

