/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.ImmutableSet;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.exceptions.checked.SaveAttachmentException;
import com.netflix.genie.web.services.AttachmentService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class FileSystemAttachmentService
implements AttachmentService {
    private static final Logger log = LoggerFactory.getLogger(FileSystemAttachmentService.class);
    private final Path attachmentDirectory;

    public FileSystemAttachmentService(String attachmentsDirectory) {
        String attachmentsDirectoryPath = attachmentsDirectory;
        if (!attachmentsDirectoryPath.endsWith(File.separator)) {
            attachmentsDirectoryPath = attachmentsDirectory + File.separator;
        }
        try {
            this.attachmentDirectory = Files.createDirectories(Paths.get(new URI(attachmentsDirectoryPath)), new FileAttribute[0]);
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create attachment directory: " + attachmentsDirectoryPath, e);
        }
    }

    @Override
    public void save(String jobId, String filename, InputStream content) throws GenieException {
        try {
            this.writeAttachments(jobId, (Set<Resource>)ImmutableSet.of((Object)((Object)new AttachmentResource(filename, content))));
        }
        catch (IOException ioe) {
            throw new GenieServerException("Failed to save attachment", (Throwable)ioe);
        }
    }

    @Override
    public void copy(String jobId, File destination) throws GenieException {
        if (destination.exists() && !destination.isDirectory()) {
            throw new GeniePreconditionException(destination + " is not a directory and it needs to be.");
        }
        try {
            this.copyAll(jobId, destination.toPath());
        }
        catch (IOException ioe) {
            throw new GenieServerException("Failed to copy attachment directory", (Throwable)ioe);
        }
    }

    @Override
    public void delete(String jobId) throws GenieException {
        try {
            this.deleteAll(jobId);
        }
        catch (IOException ioe) {
            throw new GenieServerException("Failed to delete directory " + jobId, (Throwable)ioe);
        }
    }

    @Override
    public String saveAll(Map<String, InputStream> attachments) throws IOException {
        String requestId = UUID.randomUUID().toString();
        this.writeAttachments(requestId, attachments.entrySet().stream().map(entry -> new AttachmentResource((String)entry.getKey(), (InputStream)entry.getValue())).collect(Collectors.toSet()));
        return requestId;
    }

    @Override
    public void copyAll(String id, Path destination) throws IOException {
        Files.createDirectories(destination, new FileAttribute[0]);
        Path attachmentDir = this.attachmentDirectory.resolve(id);
        if (Files.exists(attachmentDir, new LinkOption[0]) && Files.isDirectory(attachmentDir, new LinkOption[0])) {
            FileUtils.copyDirectory((File)attachmentDir.toFile(), (File)destination.toFile());
        }
    }

    @Override
    public void deleteAll(String id) throws IOException {
        this.deleteAttachments(id);
    }

    @Override
    public Set<URI> saveAttachments(String jobId, Set<Resource> attachments) throws SaveAttachmentException {
        try {
            return this.writeAttachments(jobId, attachments);
        }
        catch (IOException ioe) {
            throw new SaveAttachmentException(ioe);
        }
    }

    @Override
    public void deleteAttachments(String jobId) throws IOException {
        Path attachmentDir = this.attachmentDirectory.resolve(jobId);
        FileUtils.deleteDirectory((File)attachmentDir.toFile());
    }

    private Set<URI> writeAttachments(String id, Set<Resource> attachments) throws IOException {
        if (attachments.isEmpty()) {
            return ImmutableSet.of();
        }
        Path requestDir = Files.createDirectories(this.attachmentDirectory.resolve(id), new FileAttribute[0]);
        ImmutableSet.Builder uris = ImmutableSet.builder();
        for (Resource attachment : attachments) {
            String rawFilename = attachment.getFilename() == null ? UUID.randomUUID().toString() : attachment.getFilename();
            Path fileName = Paths.get(rawFilename, new String[0]).getFileName();
            Path file = requestDir.resolve(fileName);
            try (InputStream contents = attachment.getInputStream();){
                long byteCount = Files.copy(contents, file, new CopyOption[0]);
                log.debug("Wrote {} bytes for attachment {} to {}", new Object[]{byteCount, fileName, file});
            }
            uris.add((Object)file.toUri());
        }
        return uris.build();
    }

    private static class AttachmentResource
    extends AbstractResource {
        private final String filename;
        private final InputStream contents;

        private AttachmentResource(String filename, InputStream contents) {
            this.filename = filename;
            this.contents = contents;
        }

        public String getFilename() {
            return this.filename;
        }

        @Nonnull
        public String getDescription() {
            return "Temporary resource for " + this.filename;
        }

        @Nonnull
        public InputStream getInputStream() throws IOException {
            return this.contents;
        }
    }
}

