/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.services.FileTransfer;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

public class HttpFileTransferImpl
implements FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(HttpFileTransferImpl.class);
    static final String DOWNLOAD_TIMER_NAME = "genie.files.http.download.timer";
    static final String UPLOAD_TIMER_NAME = "genie.files.http.upload.timer";
    static final String GET_LAST_MODIFIED_TIMER_NAME = "genie.files.http.getLastModified.timer";
    private final UrlValidator validator = new UrlValidator(new String[]{"http", "https"}, 8L);
    private final RestTemplate restTemplate;
    private final MeterRegistry registry;

    public HttpFileTransferImpl(@NotNull RestTemplate restTemplate, @NotNull MeterRegistry registry) {
        this.restTemplate = restTemplate;
        this.registry = registry;
    }

    @Override
    public boolean isValid(String fileName) throws GenieException {
        log.debug("Called with file name {}", (Object)fileName);
        return this.validator.isValid(fileName);
    }

    @Override
    public void getFile(@NotBlank(message="Source file path cannot be empty.") @NotBlank(message="Source file path cannot be empty.") String srcRemotePath, @NotBlank(message="Destination local path cannot be empty") @NotBlank(message="Destination local path cannot be empty") String dstLocalPath) throws GenieException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        log.debug("Called with src path {} and destination path {}", (Object)srcRemotePath, (Object)dstLocalPath);
        try {
            File outputFile = new File(dstLocalPath);
            if (!this.isValid(srcRemotePath)) {
                throw new GenieServerException("Unable to download " + srcRemotePath + " not a valid URL");
            }
            this.restTemplate.execute(srcRemotePath, HttpMethod.GET, requestEntity -> requestEntity.getHeaders().setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.ALL})), response -> {
                FileUtils.copyInputStreamToFile((InputStream)response.getBody(), (File)outputFile);
                return null;
            }, new Object[0]);
            MetricsUtils.addSuccessTags(tags);
        }
        catch (GenieException | RuntimeException e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        finally {
            this.registry.timer(DOWNLOAD_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void putFile(@NotBlank(message="Source local path cannot be empty.") @NotBlank(message="Source local path cannot be empty.") String srcLocalPath, @NotBlank(message="Destination remote path cannot be empty") @NotBlank(message="Destination remote path cannot be empty") String dstRemotePath) throws GenieException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            try {
                throw new UnsupportedOperationException("Saving a file to an HttpEndpoint isn't implemented in this version");
            }
            catch (Throwable t) {
                MetricsUtils.addFailureTagsWithException(tags, t);
                throw t;
            }
        }
        catch (Throwable throwable) {
            this.registry.timer(UPLOAD_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            throw throwable;
        }
    }

    @Override
    public long getLastModifiedTime(String path) throws GenieException {
        long lastModtime;
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            URL url = new URL(path);
            long time = this.restTemplate.headForHeaders(url.toURI()).getLastModified();
            lastModtime = time != -1L ? time : Instant.now().toEpochMilli();
            MetricsUtils.addSuccessTags(tags);
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw new GenieServerException("Failed to get metadata for invalid URL", (Throwable)e);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.registry.timer(GET_LAST_MODIFIED_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        return lastModtime;
    }
}

