/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.events.JobScheduledEvent;
import com.netflix.genie.web.jobs.JobLauncher;
import com.netflix.genie.web.services.JobStateService;
import com.netflix.genie.web.services.JobSubmitterService;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Supplier;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

public class JobStateServiceImpl
implements JobStateService {
    private static final Logger log = LoggerFactory.getLogger(JobStateServiceImpl.class);
    protected final TaskScheduler scheduler;
    protected final MeterRegistry registry;
    protected final GenieEventBus genieEventBus;
    private final Map<String, JobInfo> jobs = Collections.synchronizedMap(new HashMap());
    private final JobSubmitterService jobSubmitterService;
    private final Counter unableToCancel;

    public JobStateServiceImpl(JobSubmitterService jobSubmitterService, TaskScheduler scheduler, GenieEventBus genieEventBus, MeterRegistry registry) {
        this.jobSubmitterService = jobSubmitterService;
        this.scheduler = scheduler;
        this.registry = registry;
        this.genieEventBus = genieEventBus;
        this.unableToCancel = registry.counter("genie.jobs.unableToCancel.rate", new String[0]);
    }

    @Override
    public void init(String jobId) {
        this.jobs.putIfAbsent(jobId, new JobInfo());
    }

    @Override
    public void schedule(String jobId, JobRequest jobRequest, Cluster cluster, Command command, List<Application> applications, int memory) {
        this.handle(jobId, () -> {
            JobInfo jobInfo = this.jobs.get(jobId);
            jobInfo.setMemory(memory);
            JobLauncher jobLauncher = new JobLauncher(this.jobSubmitterService, jobRequest, cluster, command, applications, memory, this.registry);
            ScheduledFuture task = this.scheduler.schedule((Runnable)jobLauncher, Instant.now().toDate());
            jobInfo.setRunningTask(task);
            jobInfo.setActive(true);
            this.genieEventBus.publishSynchronousEvent(new JobScheduledEvent(jobId, task, memory, this));
            return null;
        });
    }

    @Override
    public void done(String jobId) throws GenieException {
        this.handle(jobId, () -> {
            JobInfo jobInfo = this.jobs.get(jobId);
            Future<?> task = jobInfo.getRunningTask();
            if (task != null && !task.isDone()) {
                if (task.cancel(true)) {
                    log.debug("Successfully cancelled job task for job {}", (Object)jobId);
                } else {
                    log.error("Unable to cancel job task for job {}", (Object)jobId);
                    this.unableToCancel.increment();
                }
            }
            this.jobs.remove(jobId);
            return null;
        });
    }

    @Override
    public boolean jobExists(String jobId) {
        return this.jobs.containsKey(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(String jobId, Supplier<Void> supplier) {
        JobInfo jobInfo = this.jobs.get(jobId);
        if (jobInfo != null) {
            JobInfo jobInfo2 = jobInfo;
            synchronized (jobInfo2) {
                jobInfo = this.jobs.get(jobId);
                if (jobInfo != null) {
                    supplier.get();
                }
            }
        }
    }

    protected void setMemoryAndTask(String jobId, int memory, Future<?> task) {
        this.handle(jobId, () -> {
            JobInfo jobInfo = this.jobs.get(jobId);
            jobInfo.setMemory(memory);
            jobInfo.setRunningTask(task);
            jobInfo.setActive(true);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumActiveJobs() {
        Map<String, JobInfo> map = this.jobs;
        synchronized (map) {
            return (int)this.jobs.values().stream().filter(JobInfo::isActive).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUsedMemory() {
        Map<String, JobInfo> map = this.jobs;
        synchronized (map) {
            return this.jobs.values().stream().map(JobInfo::getMemory).reduce(Integer::sum).orElse(0);
        }
    }

    private static class JobInfo {
        private Future<?> runningTask;
        private Integer memory = 0;
        private boolean active;

        private JobInfo() {
        }

        public Future<?> getRunningTask() {
            return this.runningTask;
        }

        public Integer getMemory() {
            return this.memory;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setRunningTask(Future<?> runningTask) {
            this.runningTask = runningTask;
        }

        public void setMemory(Integer memory) {
            this.memory = memory;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

