/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.data;

import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.data.services.impl.jpa.JpaPersistenceServiceImpl;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaAgentConnectionRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaApplicationRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaCriterionRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaFileRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaJobRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaRepositories;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaTagRepository;
import com.netflix.genie.web.services.AttachmentService;
import javax.persistence.EntityManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@EnableJpaRepositories(value={"com.netflix.genie.web.data.services.impl.jpa.repositories"})
@EntityScan(value={"com.netflix.genie.web.data.services.impl.jpa.entities"})
public class DataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DataServices.class})
    public DataServices genieDataServices(PersistenceService persistenceService) {
        return new DataServices(persistenceService);
    }

    @Bean
    @ConditionalOnMissingBean(value={JpaRepositories.class})
    public JpaRepositories genieJpaRepositories(JpaAgentConnectionRepository agentConnectionRepository, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository, JpaCriterionRepository criterionRepository, JpaFileRepository fileRepository, JpaJobRepository jobRepository, JpaTagRepository tagRepository) {
        return new JpaRepositories(agentConnectionRepository, applicationRepository, clusterRepository, commandRepository, criterionRepository, fileRepository, jobRepository, tagRepository);
    }

    @Bean
    @ConditionalOnMissingBean(value={PersistenceService.class})
    public JpaPersistenceServiceImpl geniePersistenceService(EntityManager entityManager, JpaRepositories jpaRepositories, AttachmentService attachmentService) {
        return new JpaPersistenceServiceImpl(entityManager, jpaRepositories, attachmentService);
    }
}

