/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.tasks.leader;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.properties.AgentCleanupProperties;
import com.netflix.genie.web.properties.ArchiveStatusCleanupProperties;
import com.netflix.genie.web.properties.ClusterCheckerProperties;
import com.netflix.genie.web.properties.DatabaseCleanupProperties;
import com.netflix.genie.web.properties.LeadershipProperties;
import com.netflix.genie.web.properties.UserMetricsProperties;
import com.netflix.genie.web.services.ClusterLeaderService;
import com.netflix.genie.web.services.impl.ClusterLeaderServiceCuratorImpl;
import com.netflix.genie.web.services.impl.ClusterLeaderServiceLocalLeaderImpl;
import com.netflix.genie.web.spring.actuators.LeaderElectionActuator;
import com.netflix.genie.web.spring.autoconfigure.ZookeeperAutoConfiguration;
import com.netflix.genie.web.spring.autoconfigure.tasks.TasksAutoConfiguration;
import com.netflix.genie.web.tasks.leader.AgentJobCleanupTask;
import com.netflix.genie.web.tasks.leader.ArchiveStatusCleanupTask;
import com.netflix.genie.web.tasks.leader.ClusterCheckerTask;
import com.netflix.genie.web.tasks.leader.DatabaseCleanupTask;
import com.netflix.genie.web.tasks.leader.LeaderTask;
import com.netflix.genie.web.tasks.leader.LeaderTasksCoordinator;
import com.netflix.genie.web.tasks.leader.LocalLeader;
import com.netflix.genie.web.tasks.leader.UserMetricsTask;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.integration.zookeeper.leader.LeaderInitiator;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={AgentCleanupProperties.class, ArchiveStatusCleanupProperties.class, ClusterCheckerProperties.class, DatabaseCleanupProperties.class, LeadershipProperties.class, UserMetricsProperties.class})
@AutoConfigureAfter(value={TasksAutoConfiguration.class, ZookeeperAutoConfiguration.class})
public class LeaderAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LeaderTasksCoordinator.class})
    public LeaderTasksCoordinator leaderTasksCoordinator(@Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, Set<LeaderTask> tasks) {
        return new LeaderTasksCoordinator(taskScheduler, tasks);
    }

    @Bean
    @ConditionalOnMissingBean(value={ClusterCheckerTask.class})
    public ClusterCheckerTask clusterCheckerTask(GenieHostInfo genieHostInfo, ClusterCheckerProperties properties, DataServices dataServices, @Qualifier(value="genieRestTemplate") RestTemplate restTemplate, WebEndpointProperties webEndpointProperties, MeterRegistry registry) {
        return new ClusterCheckerTask(genieHostInfo, properties, dataServices, restTemplate, webEndpointProperties, registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.database-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={DatabaseCleanupTask.class})
    public DatabaseCleanupTask databaseCleanupTask(DatabaseCleanupProperties cleanupProperties, Environment environment, DataServices dataServices, MeterRegistry registry) {
        return new DatabaseCleanupTask(cleanupProperties, environment, dataServices, registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.user-metrics.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={UserMetricsTask.class})
    public UserMetricsTask userMetricsTask(MeterRegistry registry, DataServices dataServices, UserMetricsProperties userMetricsProperties) {
        return new UserMetricsTask(registry, dataServices, userMetricsProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.agent-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={AgentJobCleanupTask.class})
    public AgentJobCleanupTask agentJobCleanupTask(DataServices dataServices, AgentCleanupProperties agentCleanupProperties, MeterRegistry registry, AgentRoutingService agentRoutingService) {
        return new AgentJobCleanupTask(dataServices, agentCleanupProperties, registry, agentRoutingService);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.archive-status-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={ArchiveStatusCleanupTask.class})
    public ArchiveStatusCleanupTask archiveStatusCleanupTask(DataServices dataServices, AgentRoutingService agentRoutingService, ArchiveStatusCleanupProperties archiveStatusCleanupProperties, MeterRegistry registry) {
        return new ArchiveStatusCleanupTask(dataServices, agentRoutingService, archiveStatusCleanupProperties, registry);
    }

    @Bean
    @ConditionalOnBean(value={LeaderInitiator.class})
    @ConditionalOnMissingBean(value={ClusterLeaderService.class})
    public ClusterLeaderService curatorClusterLeaderService(LeaderInitiator leaderInitiator) {
        return new ClusterLeaderServiceCuratorImpl(leaderInitiator);
    }

    @Bean
    @ConditionalOnMissingBean(value={LeaderInitiator.class, LocalLeader.class})
    public LocalLeader localLeader(GenieEventBus genieEventBus, LeadershipProperties leadershipProperties) {
        return new LocalLeader(genieEventBus, leadershipProperties.isEnabled());
    }

    @Bean
    @ConditionalOnBean(value={LocalLeader.class})
    @ConditionalOnMissingBean(value={ClusterLeaderService.class})
    public ClusterLeaderService localClusterLeaderService(LocalLeader localLeader) {
        return new ClusterLeaderServiceLocalLeaderImpl(localLeader);
    }

    @Bean
    @ConditionalOnBean(value={ClusterLeaderService.class})
    @ConditionalOnMissingBean(value={LeaderElectionActuator.class})
    public LeaderElectionActuator leaderElectionActuator(ClusterLeaderService clusterLeaderService) {
        return new LeaderElectionActuator(clusterLeaderService);
    }
}

