/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.RootModelAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v3"})
public class RootRestController {
    private static final Logger log = LoggerFactory.getLogger(RootRestController.class);
    private final RootModelAssembler rootModelAssembler;

    @Autowired
    public RootRestController(RootModelAssembler rootModelAssembler) {
        this.rootModelAssembler = rootModelAssembler;
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<JsonNode> getRoot() {
        JsonNodeFactory factory = JsonNodeFactory.instance;
        JsonNode node = factory.objectNode().set("description", (JsonNode)factory.textNode("Genie V3 API"));
        return this.rootModelAssembler.toModel(node);
    }
}

