/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.converters;

import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.external.dtos.v4.ArchiveStatus;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.web.data.services.impl.jpa.converters.EntityV4DtoConverters;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.aggregates.UserJobResourcesAggregate;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobExecutionProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobMetadataProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobRequestProjection;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityV3DtoConverters {
    private static final Logger log = LoggerFactory.getLogger(EntityV3DtoConverters.class);

    private EntityV3DtoConverters() {
    }

    public static Job toJobDto(JobProjection jobProjection) {
        Job.Builder builder = ((Job.Builder)((Job.Builder)((Job.Builder)((Job.Builder)new Job.Builder(jobProjection.getName(), jobProjection.getUser(), jobProjection.getVersion()).withId(jobProjection.getUniqueId())).withCreated(jobProjection.getCreated())).withUpdated(jobProjection.getUpdated())).withTags(jobProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withStatus(DtoConverters.toV3JobStatus((JobStatus)DtoConverters.toV4JobStatus((String)jobProjection.getStatus()))).withCommandArgs(jobProjection.getCommandArgs());
        jobProjection.getDescription().ifPresent(arg_0 -> ((Job.Builder)builder).withDescription(arg_0));
        jobProjection.getStatusMsg().ifPresent(arg_0 -> ((Job.Builder)builder).withStatusMsg(arg_0));
        jobProjection.getStarted().ifPresent(arg_0 -> ((Job.Builder)builder).withStarted(arg_0));
        jobProjection.getFinished().ifPresent(arg_0 -> ((Job.Builder)builder).withFinished(arg_0));
        jobProjection.getArchiveLocation().ifPresent(arg_0 -> ((Job.Builder)builder).withArchiveLocation(arg_0));
        jobProjection.getClusterName().ifPresent(arg_0 -> ((Job.Builder)builder).withClusterName(arg_0));
        jobProjection.getCommandName().ifPresent(arg_0 -> ((Job.Builder)builder).withCommandName(arg_0));
        jobProjection.getGrouping().ifPresent(arg_0 -> ((Job.Builder)builder).withGrouping(arg_0));
        jobProjection.getGroupingInstance().ifPresent(arg_0 -> ((Job.Builder)builder).withGroupingInstance(arg_0));
        jobProjection.getMetadata().ifPresent(arg_0 -> ((Job.Builder)builder).withMetadata(arg_0));
        return builder.build();
    }

    public static JobRequest toJobRequestDto(JobRequestProjection jobRequestProjection) {
        JobRequest.Builder builder = ((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)new JobRequest.Builder(jobRequestProjection.getName(), jobRequestProjection.getUser(), jobRequestProjection.getVersion(), jobRequestProjection.getClusterCriteria().stream().map(EntityV4DtoConverters::toCriterionDto).map(DtoConverters::toClusterCriteria).collect(Collectors.toList()), (Set)DtoConverters.toV3CriterionTags((Criterion)EntityV4DtoConverters.toCriterionDto(jobRequestProjection.getCommandCriterion()))).withCreated(jobRequestProjection.getCreated())).withId(jobRequestProjection.getUniqueId())).withDisableLogArchival(jobRequestProjection.isArchivingDisabled()).withConfigs(jobRequestProjection.getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet()))).withDependencies(jobRequestProjection.getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet()))).withTags(jobRequestProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withUpdated(jobRequestProjection.getUpdated())).withApplications(jobRequestProjection.getRequestedApplications()).withCommandArgs(jobRequestProjection.getCommandArgs());
        jobRequestProjection.getEmail().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withEmail(arg_0));
        jobRequestProjection.getGenieUserGroup().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGroup(arg_0));
        jobRequestProjection.getDescription().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withDescription(arg_0));
        jobRequestProjection.getRequestedCpu().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withCpu(arg_0));
        jobRequestProjection.getRequestedMemory().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withMemory(arg_0));
        jobRequestProjection.getRequestedTimeout().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withTimeout(arg_0));
        jobRequestProjection.getSetupFile().ifPresent(setupFileEntity -> {
            JobRequest.Builder cfr_ignored_0 = (JobRequest.Builder)builder.withSetupFile(setupFileEntity.getFile());
        });
        jobRequestProjection.getGrouping().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGrouping(arg_0));
        jobRequestProjection.getGroupingInstance().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGroupingInstance(arg_0));
        jobRequestProjection.getMetadata().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withMetadata(arg_0));
        return builder.build();
    }

    public static JobExecution toJobExecutionDto(JobExecutionProjection jobExecutionProjection) {
        JobExecution.Builder builder = (JobExecution.Builder)((JobExecution.Builder)((JobExecution.Builder)new JobExecution.Builder(jobExecutionProjection.getAgentHostname().orElse(UUID.randomUUID().toString())).withId(jobExecutionProjection.getUniqueId())).withCreated(jobExecutionProjection.getCreated())).withUpdated(jobExecutionProjection.getUpdated());
        jobExecutionProjection.getProcessId().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withProcessId(arg_0));
        jobExecutionProjection.getCheckDelay().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withCheckDelay(arg_0));
        if (jobExecutionProjection.getStarted().isPresent() && jobExecutionProjection.getTimeoutUsed().isPresent()) {
            Instant started = jobExecutionProjection.getStarted().get();
            builder.withTimeout(started.plusSeconds(jobExecutionProjection.getTimeoutUsed().get().intValue()));
        }
        jobExecutionProjection.getExitCode().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withExitCode(arg_0));
        jobExecutionProjection.getMemoryUsed().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withMemory(arg_0));
        try {
            builder.withArchiveStatus(ArchiveStatus.valueOf((String)jobExecutionProjection.getArchiveStatus().orElseThrow(IllegalArgumentException::new)));
        }
        catch (IllegalArgumentException e) {
            builder.withArchiveStatus(ArchiveStatus.UNKNOWN);
        }
        return builder.build();
    }

    public static JobMetadata toJobMetadataDto(JobMetadataProjection jobMetadataProjection) {
        JobMetadata.Builder builder = (JobMetadata.Builder)((JobMetadata.Builder)((JobMetadata.Builder)new JobMetadata.Builder().withId(jobMetadataProjection.getUniqueId())).withCreated(jobMetadataProjection.getCreated())).withUpdated(jobMetadataProjection.getUpdated());
        jobMetadataProjection.getRequestApiClientHostname().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withClientHost(arg_0));
        jobMetadataProjection.getRequestApiClientUserAgent().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withUserAgent(arg_0));
        jobMetadataProjection.getNumAttachments().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withNumAttachments(arg_0));
        jobMetadataProjection.getTotalSizeOfAttachments().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withTotalSizeOfAttachments(arg_0));
        jobMetadataProjection.getStdErrSize().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withStdErrSize(arg_0));
        jobMetadataProjection.getStdOutSize().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withStdOutSize(arg_0));
        return builder.build();
    }

    public static UserResourcesSummary toUserResourceSummaryDto(UserJobResourcesAggregate userJobResourcesAggregate) {
        String user = userJobResourcesAggregate.getUser();
        Long jobCount = userJobResourcesAggregate.getRunningJobsCount();
        Long memory = userJobResourcesAggregate.getUsedMemory();
        return new UserResourcesSummary(user == null ? "NULL" : user, jobCount == null ? 0L : jobCount, memory == null ? 0L : memory);
    }
}

