/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.queries.predicates;

import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.JobEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.JobEntity_;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.PredicateUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;

public final class JobPredicates {
    private JobPredicates() {
    }

    public static Predicate getFindPredicate(Root<JobEntity> root, CriteriaBuilder cb, @Nullable String id, @Nullable String name, @Nullable String user, @Nullable Set<String> statuses, @Nullable Set<String> tags, @Nullable String clusterName, @Nullable ClusterEntity cluster, @Nullable String commandName, @Nullable CommandEntity command, @Nullable Instant minStarted, @Nullable Instant maxStarted, @Nullable Instant minFinished, @Nullable Instant maxFinished, @Nullable String grouping, @Nullable String groupingInstance) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(JobEntity_.uniqueId), id));
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(JobEntity_.name), name));
        }
        if (StringUtils.isNotBlank((CharSequence)user)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(JobEntity_.user), user));
        }
        if (statuses != null && !statuses.isEmpty()) {
            predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(JobEntity_.status), status)).toArray(Predicate[]::new)));
        }
        if (tags != null && !tags.isEmpty()) {
            predicates.add(cb.like((Expression)root.get(JobEntity_.tagSearchString), PredicateUtils.getTagLikeString(tags)));
        }
        if (cluster != null) {
            predicates.add(cb.equal((Expression)root.get(JobEntity_.cluster), (Object)cluster));
        }
        if (StringUtils.isNotBlank((CharSequence)clusterName)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(JobEntity_.clusterName), clusterName));
        }
        if (command != null) {
            predicates.add(cb.equal((Expression)root.get(JobEntity_.command), (Object)command));
        }
        if (StringUtils.isNotBlank((CharSequence)commandName)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(JobEntity_.commandName), commandName));
        }
        if (minStarted != null) {
            predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(JobEntity_.started), (Comparable)minStarted));
        }
        if (maxStarted != null) {
            predicates.add(cb.lessThan((Expression)root.get(JobEntity_.started), (Comparable)maxStarted));
        }
        if (minFinished != null) {
            predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(JobEntity_.finished), (Comparable)minFinished));
        }
        if (maxFinished != null) {
            predicates.add(cb.lessThan((Expression)root.get(JobEntity_.finished), (Comparable)maxFinished));
        }
        if (grouping != null) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(JobEntity_.grouping), grouping));
        }
        if (groupingInstance != null) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(JobEntity_.groupingInstance), groupingInstance));
        }
        return cb.and(predicates.toArray(new Predicate[0]));
    }
}

