/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerMapping;

public final class ControllerUtils {
    private static final Logger log = LoggerFactory.getLogger(ControllerUtils.class);
    private static final String EMPTY_STRING = "";

    private ControllerUtils() {
    }

    public static String getRemainingPath(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path != null) {
            String bestMatchPattern = (String)request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
            log.debug("bestMatchPattern = {}", (Object)bestMatchPattern);
            path = new AntPathMatcher().extractPathWithinPattern(bestMatchPattern, path);
        }
        path = path == null ? EMPTY_STRING : path;
        log.debug("Remaining path = {}", (Object)path);
        return path;
    }

    static URL getRequestRoot(HttpServletRequest request, @Nullable String path) throws MalformedURLException {
        return ControllerUtils.getRequestRoot(new URL(request.getRequestURL().toString()), path);
    }

    static URL getRequestRoot(URL request, @Nullable String path) throws MalformedURLException {
        String currentPath = request.getPath();
        String newPath = StringUtils.removeEnd((String)currentPath, (String)path);
        return new URL(request.getProtocol(), request.getHost(), request.getPort(), newPath);
    }
}

