/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.queries.predicates;

import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.PredicateUtils;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import org.apache.commons.lang3.StringUtils;

public final class ApplicationPredicates {
    private ApplicationPredicates() {
    }

    public static Predicate find(Root<ApplicationEntity> root, CriteriaQuery<?> cq, CriteriaBuilder cb, @Nullable String name, @Nullable String user, @Nullable Set<String> statuses, @Nullable Set<TagEntity> tags, @Nullable String type) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ApplicationEntity_.name), name));
        }
        if (StringUtils.isNotBlank((CharSequence)user)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ApplicationEntity_.user), user));
        }
        if (statuses != null && !statuses.isEmpty()) {
            predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(ApplicationEntity_.status), status)).toArray(Predicate[]::new)));
        }
        if (tags != null && !tags.isEmpty()) {
            SetJoin tagEntityJoin = root.join(ApplicationEntity_.tags);
            predicates.add(tagEntityJoin.in(tags));
            cq.groupBy(new Expression[]{root.get(ApplicationEntity_.id)});
            cq.having((Expression)cb.equal(cb.count((Expression)root.get(ApplicationEntity_.id)), (Object)tags.size()));
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ApplicationEntity_.type), type));
        }
        return cb.and(predicates.toArray(new Predicate[0]));
    }
}

