/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.actuators;

import com.google.common.collect.ImmutableMap;
import com.netflix.genie.web.services.ClusterLeaderService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="leaderElection")
public class LeaderElectionActuator {
    private static final Logger log = LoggerFactory.getLogger(LeaderElectionActuator.class);
    private static final String RUNNING = "running";
    private static final String LEADER = "leader";
    private final ClusterLeaderService clusterLeaderService;

    public LeaderElectionActuator(ClusterLeaderService clusterLeaderService) {
        this.clusterLeaderService = clusterLeaderService;
    }

    @ReadOperation
    public Map<String, Object> getStatus() {
        return ImmutableMap.builder().put((Object)RUNNING, (Object)this.clusterLeaderService.isRunning()).put((Object)LEADER, (Object)this.clusterLeaderService.isLeader()).build();
    }

    @WriteOperation
    public void doAction(Action action) {
        switch (action) {
            case START: {
                log.info("Starting leader election service");
                this.clusterLeaderService.start();
                break;
            }
            case STOP: {
                log.info("Stopping leader election service");
                this.clusterLeaderService.stop();
                break;
            }
            case RESTART: {
                log.info("Restarting leader election service");
                this.clusterLeaderService.stop();
                this.clusterLeaderService.start();
                break;
            }
            default: {
                log.error("Unknown action: " + (Object)((Object)action));
                throw new UnsupportedOperationException("Unknown action: " + action.name());
            }
        }
    }

    public static enum Action {
        STOP,
        START,
        RESTART,
        TEST;

    }
}

