/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClientBuilder;
import com.netflix.genie.web.properties.RetryProperties;
import com.netflix.genie.web.properties.SNSNotificationsProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RetryProperties.class, SNSNotificationsProperties.class})
public class AWSAutoConfiguration {
    public static final String SNS_CLIENT_BEAN_NAME = "amazonSNS";
    private static final String SNS_CLIENT_CONFIGURATION_BEAN_NAME = "SNSClientConfiguration";
    private static final String SNS_CLIENT_RETRY_POLICY_BEAN_NAME = "SNSClientRetryPolicy";

    @Bean(name={"SNSClientRetryPolicy"})
    @ConditionalOnMissingBean(name={"SNSClientRetryPolicy"})
    public RetryPolicy jobNotificationsSNSClientRetryPolicy(RetryProperties retryProperties) {
        return PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)retryProperties.getSns().getNoOfRetries());
    }

    @Bean(name={"SNSClientConfiguration"})
    @ConditionalOnMissingBean(name={"SNSClientConfiguration"})
    public ClientConfiguration jobNotificationsSNSClientConfiguration(@Qualifier(value="SNSClientRetryPolicy") RetryPolicy retryPolicy) {
        ClientConfiguration configuration = new ClientConfigurationFactory().getConfig();
        configuration.setRetryPolicy(retryPolicy);
        return configuration;
    }

    @Bean(name={"amazonSNS"})
    @ConditionalOnMissingBean(name={"amazonSNS"})
    @ConditionalOnProperty(value={"genie.notifications.sns.enabled"}, havingValue="true")
    public AmazonSNS jobNotificationsSNSClient(AWSCredentialsProvider credentialsProvider, AwsRegionProvider awsRegionProvider, @Qualifier(value="SNSClientConfiguration") ClientConfiguration clientConfiguration) {
        return (AmazonSNS)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)((AmazonSNSClientBuilder)AmazonSNSClientBuilder.standard().withCredentials(credentialsProvider)).withRegion(awsRegionProvider.getRegion())).withClientConfiguration(clientConfiguration)).build();
    }
}

