/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.jobs;

import com.netflix.genie.common.internal.aws.s3.S3ClientFactory;
import com.netflix.genie.common.internal.services.JobDirectoryManifestCreatorService;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.jobs.workflow.impl.ApplicationTask;
import com.netflix.genie.web.jobs.workflow.impl.ClusterTask;
import com.netflix.genie.web.jobs.workflow.impl.CommandTask;
import com.netflix.genie.web.jobs.workflow.impl.InitialSetupTask;
import com.netflix.genie.web.jobs.workflow.impl.JobFailureAndKillHandlerLogicTask;
import com.netflix.genie.web.jobs.workflow.impl.JobKickoffTask;
import com.netflix.genie.web.jobs.workflow.impl.JobTask;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.properties.S3FileTransferProperties;
import com.netflix.genie.web.scripts.ExecutionModeFilterScript;
import com.netflix.genie.web.services.AttachmentService;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.services.impl.HttpFileTransferImpl;
import com.netflix.genie.web.services.impl.LocalFileTransferImpl;
import com.netflix.genie.web.services.impl.S3FileTransferImpl;
import com.netflix.genie.web.util.JobExecutionModeSelector;
import com.netflix.genie.web.util.ProcessChecker;
import com.netflix.genie.web.util.UnixProcessChecker;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Optional;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={S3FileTransferProperties.class})
public class JobsAutoConfiguration {
    @Bean(name={"file.system.file", "file.system.null"})
    @Order(value=2)
    @ConditionalOnMissingBean(value={LocalFileTransferImpl.class})
    public LocalFileTransferImpl localFileTransfer() {
        return new LocalFileTransferImpl();
    }

    @Bean(name={"file.system.http", "file.system.https"})
    @Order(value=3)
    @ConditionalOnMissingBean(value={HttpFileTransferImpl.class})
    public HttpFileTransferImpl httpFileTransfer(RestTemplate restTemplate, MeterRegistry registry) {
        return new HttpFileTransferImpl(restTemplate, registry);
    }

    @Bean(name={"file.system.s3", "file.system.s3n", "file.system.s3a"})
    @Order(value=1)
    @ConditionalOnMissingBean(value={S3FileTransferImpl.class})
    @ConditionalOnBean(value={S3ClientFactory.class})
    public S3FileTransferImpl s3FileTransferImpl(S3ClientFactory s3ClientFactory, MeterRegistry registry, S3FileTransferProperties s3FileTransferProperties) {
        return new S3FileTransferImpl(s3ClientFactory, registry, s3FileTransferProperties);
    }

    @Bean
    @Order(value=0)
    @ConditionalOnMissingBean(value={JobFailureAndKillHandlerLogicTask.class})
    public JobFailureAndKillHandlerLogicTask jobKillLogicTask(MeterRegistry registry) {
        return new JobFailureAndKillHandlerLogicTask(registry);
    }

    @Bean
    @Order(value=1)
    @ConditionalOnMissingBean(value={InitialSetupTask.class})
    public InitialSetupTask initialSetupTask(MeterRegistry registry) {
        return new InitialSetupTask(registry);
    }

    @Bean
    @Order(value=2)
    @ConditionalOnMissingBean(value={ClusterTask.class})
    public ClusterTask clusterProcessorTask(MeterRegistry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new ClusterTask(registry, fts);
    }

    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean(value={ApplicationTask.class})
    public ApplicationTask applicationProcessorTask(MeterRegistry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new ApplicationTask(registry, fts);
    }

    @Bean
    @Order(value=4)
    @ConditionalOnMissingBean(value={CommandTask.class})
    public CommandTask commandProcessorTask(MeterRegistry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new CommandTask(registry, fts);
    }

    @Bean
    @Order(value=5)
    @ConditionalOnMissingBean(value={JobTask.class})
    public JobTask jobProcessorTask(AttachmentService attachmentService, MeterRegistry registry, @Qualifier(value="genieFileTransferService") GenieFileTransferService fts) {
        return new JobTask(attachmentService, registry, fts);
    }

    @Bean
    @Order(value=6)
    @ConditionalOnMissingBean(value={JobKickoffTask.class})
    public JobKickoffTask jobKickoffTask(JobsProperties jobsProperties, Executor executor, GenieHostInfo genieHostInfo, MeterRegistry registry, JobDirectoryManifestCreatorService jobDirectoryManifestCreatorService) {
        return new JobKickoffTask(jobsProperties.getUsers().isRunAsUserEnabled(), jobsProperties.getUsers().isCreationEnabled(), executor, genieHostInfo.getHostname(), registry, jobDirectoryManifestCreatorService);
    }

    @Bean
    @ConditionalOnMissingBean(value={ProcessChecker.Factory.class})
    public ProcessChecker.Factory processCheckerFactory(Executor executor, JobsProperties jobsProperties) {
        if (SystemUtils.IS_OS_UNIX) {
            return new UnixProcessChecker.Factory(executor, jobsProperties.getUsers().isRunAsUserEnabled());
        }
        throw new BeanCreationException("No implementation available for non-UNIX systems");
    }

    @Bean
    @ConditionalOnMissingBean(value={JobExecutionModeSelector.class})
    public JobExecutionModeSelector jobExecutionModeSelector(Environment environment, MeterRegistry meterRegistry, Optional<ExecutionModeFilterScript> executionModeFilterScript) {
        return new JobExecutionModeSelector(environment, meterRegistry, executionModeFilterScript.orElse(null));
    }
}

