/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.services.JobArchiveService;
import com.netflix.genie.common.internal.services.JobDirectoryManifestCreatorService;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.agent.services.AgentFileStreamService;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.jobs.workflow.WorkflowTask;
import com.netflix.genie.web.properties.ExponentialBackOffTriggerProperties;
import com.netflix.genie.web.properties.FileCacheProperties;
import com.netflix.genie.web.properties.JobsActiveLimitProperties;
import com.netflix.genie.web.properties.JobsCleanupProperties;
import com.netflix.genie.web.properties.JobsForwardingProperties;
import com.netflix.genie.web.properties.JobsLocationsProperties;
import com.netflix.genie.web.properties.JobsMaxProperties;
import com.netflix.genie.web.properties.JobsMemoryProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.properties.JobsUsersProperties;
import com.netflix.genie.web.selectors.ClusterSelector;
import com.netflix.genie.web.selectors.CommandSelector;
import com.netflix.genie.web.services.ArchivedJobService;
import com.netflix.genie.web.services.AttachmentService;
import com.netflix.genie.web.services.FileTransferFactory;
import com.netflix.genie.web.services.JobCoordinatorService;
import com.netflix.genie.web.services.JobDirectoryServerService;
import com.netflix.genie.web.services.JobFileService;
import com.netflix.genie.web.services.JobKillService;
import com.netflix.genie.web.services.JobKillServiceV4;
import com.netflix.genie.web.services.JobLaunchService;
import com.netflix.genie.web.services.JobResolverService;
import com.netflix.genie.web.services.JobStateService;
import com.netflix.genie.web.services.JobSubmitterService;
import com.netflix.genie.web.services.MailService;
import com.netflix.genie.web.services.impl.ArchivedJobServiceImpl;
import com.netflix.genie.web.services.impl.CacheGenieFileTransferService;
import com.netflix.genie.web.services.impl.DiskJobFileServiceImpl;
import com.netflix.genie.web.services.impl.FileSystemAttachmentService;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.services.impl.JobCoordinatorServiceImpl;
import com.netflix.genie.web.services.impl.JobDirectoryServerServiceImpl;
import com.netflix.genie.web.services.impl.JobKillServiceImpl;
import com.netflix.genie.web.services.impl.JobKillServiceV3;
import com.netflix.genie.web.services.impl.JobLaunchServiceImpl;
import com.netflix.genie.web.services.impl.JobResolverServiceImpl;
import com.netflix.genie.web.services.impl.LocalFileTransferImpl;
import com.netflix.genie.web.services.impl.LocalJobRunner;
import com.netflix.genie.web.tasks.job.JobCompletionService;
import com.netflix.genie.web.util.ProcessChecker;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.exec.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ServiceLocatorFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableConfigurationProperties(value={FileCacheProperties.class, JobsCleanupProperties.class, JobsForwardingProperties.class, JobsLocationsProperties.class, JobsMaxProperties.class, JobsMemoryProperties.class, JobsUsersProperties.class, ExponentialBackOffTriggerProperties.class, JobsActiveLimitProperties.class})
public class ServicesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServicesAutoConfiguration.class);

    @Bean
    public JobsProperties jobsProperties(JobsCleanupProperties cleanup, JobsForwardingProperties forwarding, JobsLocationsProperties locations, JobsMaxProperties max, JobsMemoryProperties memory, JobsUsersProperties users, ExponentialBackOffTriggerProperties completionCheckBackOff, JobsActiveLimitProperties activeLimit) {
        return new JobsProperties(cleanup, forwarding, locations, max, memory, users, completionCheckBackOff, activeLimit);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobKillServiceV3.class})
    public JobKillServiceV3 jobKillServiceV3(GenieHostInfo genieHostInfo, DataServices dataServices, Executor executor, JobsProperties jobsProperties, GenieEventBus genieEventBus, @Qualifier(value="jobsDir") Resource genieWorkingDir, ObjectMapper objectMapper, ProcessChecker.Factory processCheckerFactory) {
        return new JobKillServiceV3(genieHostInfo.getHostname(), dataServices, executor, jobsProperties.getUsers().isRunAsUserEnabled(), genieEventBus, genieWorkingDir, objectMapper, processCheckerFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobKillService.class})
    public JobKillServiceImpl jobKillService(JobKillServiceV3 jobKillServiceV3, JobKillServiceV4 jobKillServiceV4, DataServices dataServices) {
        return new JobKillServiceImpl(jobKillServiceV3, jobKillServiceV4, dataServices);
    }

    @Bean
    @ConditionalOnMissingBean(name={"genieFileTransferService"})
    public GenieFileTransferService genieFileTransferService(FileTransferFactory fileTransferFactory) throws GenieException {
        return new GenieFileTransferService(fileTransferFactory);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cacheGenieFileTransferService"})
    public GenieFileTransferService cacheGenieFileTransferService(FileTransferFactory fileTransferFactory, FileCacheProperties fileCacheProperties, LocalFileTransferImpl localFileTransfer, MeterRegistry registry) throws GenieException {
        return new CacheGenieFileTransferService(fileTransferFactory, fileCacheProperties.getLocation().toString(), localFileTransfer, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobSubmitterService.class})
    public JobSubmitterService jobSubmitterService(DataServices dataServices, GenieEventBus genieEventBus, List<WorkflowTask> workflowTasks, @Qualifier(value="jobsDir") Resource genieWorkingDir, MeterRegistry registry) {
        return new LocalJobRunner(dataServices, genieEventBus, workflowTasks, genieWorkingDir, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobCoordinatorService.class})
    public JobCoordinatorService jobCoordinatorService(DataServices dataServices, JobKillService jobKillService, @Qualifier(value="jobMonitoringCoordinator") JobStateService jobStateService, JobsProperties jobsProperties, JobResolverService jobResolverService, MeterRegistry registry, GenieHostInfo genieHostInfo) {
        return new JobCoordinatorServiceImpl(dataServices, jobKillService, jobStateService, jobsProperties, jobResolverService, registry, genieHostInfo.getHostname());
    }

    @Bean
    @ConditionalOnMissingBean(value={AttachmentService.class})
    public FileSystemAttachmentService attachmentService(JobsProperties jobsProperties) {
        return new FileSystemAttachmentService(jobsProperties.getLocations().getAttachments().toString());
    }

    @Bean
    @ConditionalOnMissingBean(name={"fileTransferFactory"}, value={ServiceLocatorFactoryBean.class})
    public ServiceLocatorFactoryBean fileTransferFactory() {
        ServiceLocatorFactoryBean factoryBean = new ServiceLocatorFactoryBean();
        factoryBean.setServiceLocatorInterface(FileTransferFactory.class);
        return factoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={JobFileService.class})
    public DiskJobFileServiceImpl jobFileService(@Qualifier(value="jobsDir") Resource jobsDir) throws IOException {
        return new DiskJobFileServiceImpl(jobsDir);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobResolverService.class})
    public JobResolverServiceImpl jobResolverService(DataServices dataServices, @NotEmpty List<ClusterSelector> clusterSelectors, CommandSelector commandSelector, MeterRegistry registry, JobsProperties jobsProperties, Environment environment) {
        return new JobResolverServiceImpl(dataServices, clusterSelectors, commandSelector, registry, jobsProperties, environment);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobCompletionService.class})
    public JobCompletionService jobCompletionService(DataServices dataServices, JobArchiveService jobArchiveService, @Qualifier(value="jobsDir") Resource genieWorkingDir, MailService mailService, MeterRegistry registry, JobsProperties jobsProperties, @Qualifier(value="genieRetryTemplate") RetryTemplate retryTemplate) throws GenieException {
        return new JobCompletionService(dataServices, jobArchiveService, genieWorkingDir, mailService, registry, jobsProperties, retryTemplate);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobDirectoryServerService.class})
    public JobDirectoryServerServiceImpl jobDirectoryServerService(ResourceLoader resourceLoader, DataServices dataServices, AgentFileStreamService agentFileStreamService, ArchivedJobService archivedJobService, MeterRegistry meterRegistry, JobFileService jobFileService, JobDirectoryManifestCreatorService jobDirectoryManifestCreatorService, AgentRoutingService agentRoutingService) {
        return new JobDirectoryServerServiceImpl(resourceLoader, dataServices, agentFileStreamService, archivedJobService, meterRegistry, jobFileService, jobDirectoryManifestCreatorService, agentRoutingService);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobLaunchService.class})
    public JobLaunchServiceImpl jobLaunchService(DataServices dataServices, JobResolverService jobResolverService, AgentLauncher agentLauncher, MeterRegistry registry) {
        return new JobLaunchServiceImpl(dataServices, jobResolverService, agentLauncher, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={ArchivedJobService.class})
    public ArchivedJobServiceImpl archivedJobService(DataServices dataServices, ResourceLoader resourceLoader, MeterRegistry meterRegistry) {
        return new ArchivedJobServiceImpl(dataServices, resourceLoader, meterRegistry);
    }
}

