/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamBuffer {
    private static final Logger log = LoggerFactory.getLogger(StreamBuffer.class);
    private final Object lock = new Object();
    private final AtomicReference<StreamBufferInputStream> inputStreamRef = new AtomicReference();
    private boolean closed;
    private ByteString currentChunk;
    private int currentChunkWatermark;
    private Throwable closeCause;

    public StreamBuffer(long skipOffset) {
        this.inputStreamRef.set(new StreamBufferInputStream(this, skipOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeForError(Throwable t) {
        log.error("Closing buffer due to error: " + t.getClass().getSimpleName() + ": " + t.getMessage());
        Object object = this.lock;
        synchronized (object) {
            this.closeCause = t;
            this.closeForCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeForCompleted() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteString data) {
        Object object = this.lock;
        synchronized (object) {
            while (!this.tryWrite(data)) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting to write next chunk of data");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWrite(ByteString data) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("Attempting to write after closing");
            }
            if (this.currentChunk == null) {
                this.currentChunk = data;
                this.currentChunkWatermark = 0;
                this.lock.notifyAll();
                return true;
            }
            this.lock.notifyAll();
            return false;
        }
    }

    public InputStream getInputStream() {
        InputStream inputStream = this.inputStreamRef.getAndSet(null);
        if (inputStream == null) {
            throw new IllegalStateException("Input stream for this buffer is no longer available");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int read(byte[] destination) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.currentChunk != null) {
                    int leftInCurrentChunk = this.currentChunk.size() - this.currentChunkWatermark;
                    int bytesRead = Math.min(leftInCurrentChunk, destination.length);
                    this.currentChunk.copyTo(destination, this.currentChunkWatermark, 0, bytesRead);
                    this.currentChunkWatermark += bytesRead;
                    if (this.currentChunkWatermark == this.currentChunk.size()) {
                        this.currentChunk = null;
                        this.lock.notifyAll();
                    }
                    return bytesRead;
                }
                if (this.closed) {
                    log.debug("Buffer was closed");
                    if (this.closeCause != null) {
                        throw new IOException(this.closeCause.getMessage());
                    }
                    return -1;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while attempting read");
                    return 0;
                }
            }
        }
    }

    private static class StreamBufferInputStream
    extends InputStream {
        private final StreamBuffer streamBuffer;
        private long skipBytesLeft;

        StreamBufferInputStream(StreamBuffer streamBuffer, long skipOffset) {
            this.streamBuffer = streamBuffer;
            this.skipBytesLeft = skipOffset;
        }

        @Override
        public int read() {
            throw new NotImplementedException("Not implemented");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException("Invalid read( b[" + b.length + "], " + off + ", " + len + ")");
            }
            if (this.skipBytesLeft > 0L) {
                int maxSkipBytes = this.skipBytesLeft <= Integer.MAX_VALUE ? (int)this.skipBytesLeft : Integer.MAX_VALUE;
                int skippedBytesRead = Math.min(len, maxSkipBytes);
                System.arraycopy(new byte[skippedBytesRead], 0, b, off, skippedBytesRead);
                this.skipBytesLeft -= (long)skippedBytesRead;
                return skippedBytesRead;
            }
            byte[] temporary = new byte[len];
            int bytesRead = this.streamBuffer.read(temporary);
            if (bytesRead > 0) {
                System.arraycopy(temporary, 0, b, off, bytesRead);
            }
            return bytesRead;
        }

        @Override
        public long skip(long n) throws IOException {
            long skipped = 0L;
            if (this.skipBytesLeft > 0L) {
                skipped = Math.min(n, this.skipBytesLeft);
                this.skipBytesLeft -= skipped;
            }
            if (skipped < n) {
                skipped += super.skip(n - skipped);
            }
            return skipped;
        }
    }
}

