/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.services.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.netflix.genie.web.agent.services.AgentConfigurationService;
import com.netflix.genie.web.properties.AgentConfigurationProperties;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class AgentConfigurationServiceImpl
implements AgentConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(AgentConfigurationServiceImpl.class);
    private static final String AGENT_PROPERTIES_CACHE_KEY = "agent-properties";
    private static final String RELOAD_PROPERTIES_TIMER = "genie.services.agentConfiguration.reloadProperties.timer";
    private static final String PROPERTIES_COUNT_TAG = "numProperties";
    private final AgentConfigurationProperties agentConfigurationProperties;
    private final Environment environment;
    private final MeterRegistry registry;
    private final Pattern agentPropertiesPattern;
    private final LoadingCache<String, Map<String, String>> cache;

    public AgentConfigurationServiceImpl(AgentConfigurationProperties agentConfigurationProperties, Environment environment, MeterRegistry registry) {
        this.agentConfigurationProperties = agentConfigurationProperties;
        this.environment = environment;
        this.registry = registry;
        this.agentPropertiesPattern = Pattern.compile(this.agentConfigurationProperties.getAgentPropertiesFilterPattern(), 2);
        this.cache = Caffeine.newBuilder().expireAfterWrite(this.agentConfigurationProperties.getCacheExpirationInterval()).refreshAfterWrite(this.agentConfigurationProperties.getCacheRefreshInterval()).initialCapacity(1).build(this::loadProperties);
    }

    @Override
    public Map<String, String> getAgentProperties() {
        return (Map)this.cache.get((Object)AGENT_PROPERTIES_CACHE_KEY);
    }

    private Map<String, String> loadProperties(@NonNull String propertiesKey) {
        Map<String, String> map;
        if (!AGENT_PROPERTIES_CACHE_KEY.equals(propertiesKey)) {
            throw new IllegalArgumentException("Unknown key to load: " + propertiesKey);
        }
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        Integer numProperties = null;
        try {
            Map<String, String> properties = this.reloadAgentProperties();
            MetricsUtils.addSuccessTags(tags);
            numProperties = properties.size();
            map = properties;
            tags.add(Tag.of((String)PROPERTIES_COUNT_TAG, (String)String.valueOf(numProperties)));
        }
        catch (Throwable t) {
            try {
                MetricsUtils.addFailureTagsWithException(tags, t);
                throw t;
            }
            catch (Throwable throwable) {
                tags.add(Tag.of((String)PROPERTIES_COUNT_TAG, (String)String.valueOf(numProperties)));
                this.registry.timer(RELOAD_PROPERTIES_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                throw throwable;
            }
        }
        this.registry.timer(RELOAD_PROPERTIES_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        return map;
    }

    private Map<String, String> reloadAgentProperties() {
        MutablePropertySources propertySources = this.environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)this.environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        HashSet filteredPropertyNames = Sets.newHashSet();
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            for (String propertyName : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                if (this.agentPropertiesPattern.matcher(propertyName).matches()) {
                    log.debug("Adding matching property: {}", (Object)propertyName);
                    filteredPropertyNames.add(propertyName);
                    continue;
                }
                log.debug("Ignoring property: {}", (Object)propertyName);
            }
        }
        ImmutableMap.Builder propertiesMapBuilder = ImmutableMap.builder();
        for (String propertyName : filteredPropertyNames) {
            String propertyValue = this.environment.getProperty(propertyName);
            if (StringUtils.isBlank((CharSequence)propertyValue)) {
                log.debug("Skipping blank value property: {}", (Object)propertyName);
                continue;
            }
            propertiesMapBuilder.put((Object)propertyName, (Object)propertyValue);
        }
        return propertiesMapBuilder.build();
    }
}

