/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.repositories;

import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaBaseRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaClusterRepository
extends JpaBaseRepository<ClusterEntity> {
    public static final String FIND_UNUSED_CLUSTERS_SQL = "SELECT id FROM clusters WHERE status IN (:unusedStatuses) AND created < :clusterCreatedThreshold AND id NOT IN (SELECT DISTINCT(cluster_id) FROM jobs WHERE cluster_id IS NOT NULL)";

    @Query(value="SELECT id FROM clusters WHERE status IN (:unusedStatuses) AND created < :clusterCreatedThreshold AND id NOT IN (SELECT DISTINCT(cluster_id) FROM jobs WHERE cluster_id IS NOT NULL)", nativeQuery=true)
    public Set<Long> findUnusedClusters(@Param(value="unusedStatuses") Set<String> var1, @Param(value="clusterCreatedThreshold") Instant var2);

    @Query(value="SELECT c FROM ClusterEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Cluster.dto", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<ClusterEntity> getClusterDto(@Param(value="id") String var1);
}

